/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import org.springframework.binding.util.MapAccessor;
import org.springframework.core.style.StylerUtils;
import org.springframework.webflow.AttributeCollection;
import org.springframework.webflow.UnmodifiableAttributeMap;

public abstract class AbstractAttributeMap
implements AttributeCollection,
Serializable {
    private Map attributes;
    private transient MapAccessor attributeAccessor;

    public Map getMap() {
        return this.attributeAccessor.getMap();
    }

    public int size() {
        return this.attributes.size();
    }

    public Object get(String attributeName) {
        return this.attributes.get(attributeName);
    }

    public abstract UnmodifiableAttributeMap unmodifiable();

    public abstract AttributeCollection union(AttributeCollection var1);

    public boolean isEmpty() {
        return this.attributes.isEmpty();
    }

    public boolean contains(String attributeName) {
        return this.attributes.containsKey(attributeName);
    }

    public boolean contains(String attributeName, Class requiredType) throws IllegalArgumentException {
        return this.attributeAccessor.containsKey((Object)attributeName, requiredType);
    }

    public Object get(String attributeName, Object defaultValue) {
        return this.attributeAccessor.get((Object)attributeName, defaultValue);
    }

    public Object get(String attributeName, Class requiredType) throws IllegalArgumentException {
        return this.attributeAccessor.get((Object)attributeName, requiredType);
    }

    public Object get(String attributeName, Class requiredType, Object defaultValue) throws IllegalStateException {
        return this.attributeAccessor.get((Object)attributeName, requiredType, defaultValue);
    }

    public Object getRequired(String attributeName) throws IllegalArgumentException {
        return this.attributeAccessor.getRequired((Object)attributeName);
    }

    public Object getRequired(String attributeName, Class requiredType) throws IllegalArgumentException {
        return this.attributeAccessor.getRequired((Object)attributeName, requiredType);
    }

    public String getString(String attributeName) throws IllegalArgumentException {
        return this.attributeAccessor.getString((Object)attributeName);
    }

    public String getString(String attributeName, String defaultValue) throws IllegalArgumentException {
        return this.attributeAccessor.getString((Object)attributeName, defaultValue);
    }

    public String getRequiredString(String attributeName) throws IllegalArgumentException {
        return this.attributeAccessor.getRequiredString((Object)attributeName);
    }

    public Collection getCollection(String attributeName) throws IllegalArgumentException {
        return this.attributeAccessor.getCollection((Object)attributeName);
    }

    public Collection getCollection(String attributeName, Class requiredType) throws IllegalArgumentException {
        return this.attributeAccessor.getCollection((Object)attributeName, requiredType);
    }

    public Collection getRequiredCollection(String attributeName) throws IllegalArgumentException {
        return this.attributeAccessor.getRequiredCollection((Object)attributeName);
    }

    public Collection getRequiredCollection(String attributeName, Class requiredType) throws IllegalArgumentException {
        return this.attributeAccessor.getRequiredCollection((Object)attributeName, requiredType);
    }

    public Object[] getArray(String attributeName, Class requiredType) throws IllegalArgumentException {
        return this.attributeAccessor.getArray((Object)attributeName, requiredType);
    }

    public Object[] getRequiredArray(String attributeName, Class requiredType) throws IllegalArgumentException {
        return this.attributeAccessor.getRequiredArray((Object)attributeName, requiredType);
    }

    public Number getNumber(String attributeName, Class requiredType) throws IllegalArgumentException {
        return this.attributeAccessor.getNumber((Object)attributeName, requiredType);
    }

    public Number getNumber(String attributeName, Class requiredType, Number defaultValue) throws IllegalArgumentException {
        return this.attributeAccessor.getNumber((Object)attributeName, requiredType, defaultValue);
    }

    public Number getRequiredNumber(String attributeName, Class requiredType) throws IllegalArgumentException {
        return this.attributeAccessor.getRequiredNumber((Object)attributeName, requiredType);
    }

    public Integer getInteger(String attributeName) throws IllegalArgumentException {
        return this.attributeAccessor.getInteger((Object)attributeName);
    }

    public Integer getInteger(String attributeName, Integer defaultValue) throws IllegalArgumentException {
        return this.attributeAccessor.getInteger((Object)attributeName, defaultValue);
    }

    public Integer getRequiredInteger(String attributeName) throws IllegalArgumentException {
        return this.attributeAccessor.getRequiredInteger((Object)attributeName);
    }

    public Long getLong(String attributeName) throws IllegalArgumentException {
        return this.attributeAccessor.getLong((Object)attributeName);
    }

    public Long getLong(String attributeName, Long defaultValue) throws IllegalArgumentException {
        return this.attributeAccessor.getLong((Object)attributeName, defaultValue);
    }

    public Long getRequiredLong(String attributeName) throws IllegalArgumentException {
        return this.attributeAccessor.getRequiredLong((Object)attributeName);
    }

    public Boolean getBoolean(String attributeName) throws IllegalArgumentException {
        return this.attributeAccessor.getBoolean((Object)attributeName);
    }

    public Boolean getBoolean(String attributeName, Boolean defaultValue) throws IllegalArgumentException {
        return this.attributeAccessor.getBoolean((Object)attributeName, defaultValue);
    }

    public Boolean getRequiredBoolean(String attributeName) throws IllegalArgumentException {
        return this.attributeAccessor.getRequiredBoolean((Object)attributeName);
    }

    protected void initAttributes(Map attributes) {
        this.attributes = attributes;
        this.attributeAccessor = new MapAccessor(this.attributes);
    }

    protected Map getMapInternal() {
        return this.attributes;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.attributeAccessor = new MapAccessor(this.attributes);
    }

    public String toString() {
        return StylerUtils.style((Object)this.attributes);
    }
}

