/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow;

import java.io.Serializable;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.springframework.webflow.ParameterMap;
import org.springframework.webflow.UnmodifiableAttributeMap;

public class CollectionUtils {
    public static final UnmodifiableAttributeMap EMPTY_ATTRIBUTE_MAP = new UnmodifiableAttributeMap(Collections.EMPTY_MAP);
    public static final ParameterMap EMPTY_PARAMETER_MAP = new ParameterMap(Collections.EMPTY_MAP);
    public static final EmptyIterator EMPTY_ITERATOR = new EmptyIterator();

    private CollectionUtils() {
    }

    public static Iterator iterator(Enumeration enumeration) {
        return new EnumerationIterator(enumeration);
    }

    public static UnmodifiableAttributeMap singleEntryMap(String attributeName, Object attributeValue) {
        HashMap<String, Object> map = new HashMap<String, Object>(1, 1.0f);
        map.put(attributeName, attributeValue);
        return new UnmodifiableAttributeMap(map);
    }

    public static boolean addAllNoDuplicates(List target, Object[] objects) {
        if (objects == null || objects.length == 0) {
            return false;
        }
        boolean changed = false;
        for (int i = 0; i < objects.length; ++i) {
            if (target.contains(objects[i])) continue;
            target.add(objects[i]);
            changed = true;
        }
        return changed;
    }

    private static class EnumerationIterator
    implements Iterator {
        private Enumeration enumeration;

        public EnumerationIterator(Enumeration enumeration) {
            this.enumeration = enumeration;
        }

        public boolean hasNext() {
            return this.enumeration.hasMoreElements();
        }

        public Object next() {
            return this.enumeration.nextElement();
        }

        public void remove() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Not supported");
        }
    }

    private static class EmptyIterator
    implements Iterator,
    Serializable {
        private EmptyIterator() {
        }

        public boolean hasNext() {
            return false;
        }

        public Object next() {
            throw new UnsupportedOperationException("There are no elements");
        }

        public void remove() {
            throw new UnsupportedOperationException("There are no elements");
        }
    }
}

