/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow;

import org.springframework.binding.mapping.AttributeMapper;
import org.springframework.core.style.ToStringCreator;
import org.springframework.util.Assert;
import org.springframework.webflow.AttributeMap;
import org.springframework.webflow.Event;
import org.springframework.webflow.Flow;
import org.springframework.webflow.FlowExecutionException;
import org.springframework.webflow.FlowSession;
import org.springframework.webflow.NullViewSelector;
import org.springframework.webflow.RequestContext;
import org.springframework.webflow.RequestControlContext;
import org.springframework.webflow.State;
import org.springframework.webflow.ViewSelection;
import org.springframework.webflow.ViewSelector;

public class EndState
extends State {
    private ViewSelector viewSelector = NullViewSelector.INSTANCE;
    private AttributeMapper outputMapper;

    public EndState(Flow flow, String id) throws IllegalArgumentException {
        super(flow, id);
    }

    public ViewSelector getViewSelector() {
        return this.viewSelector;
    }

    public void setViewSelector(ViewSelector viewSelector) {
        Assert.notNull((Object)viewSelector, (String)"The view selector is required");
        this.viewSelector = viewSelector;
    }

    public AttributeMapper getOutputMapper() {
        return this.outputMapper;
    }

    public void setOutputMapper(AttributeMapper outputMapper) {
        this.outputMapper = outputMapper;
    }

    protected ViewSelection doEnter(RequestControlContext context) throws FlowExecutionException {
        FlowSession activeSession = context.getFlowExecutionContext().getActiveSession();
        if (activeSession.isRoot()) {
            ViewSelection selectedView = this.viewSelector.makeSelection(context);
            context.endActiveFlowSession(this.createSessionOutput(context));
            return selectedView;
        }
        AttributeMap sessionOutput = this.createSessionOutput(context);
        context.endActiveFlowSession(sessionOutput);
        return context.signalEvent(new Event(this, this.getId(), sessionOutput));
    }

    protected AttributeMap createSessionOutput(RequestContext context) {
        if (this.outputMapper == null) {
            return new AttributeMap();
        }
        AttributeMap outputMap = new AttributeMap();
        this.outputMapper.map((Object)context, (Object)outputMap, null);
        return outputMap;
    }

    protected void appendToString(ToStringCreator creator) {
        creator.append("viewSelector", (Object)this.viewSelector).append("outputMapper", (Object)this.outputMapper);
    }
}

