/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow;

import java.util.EventObject;
import org.springframework.util.Assert;
import org.springframework.webflow.AttributeCollection;
import org.springframework.webflow.CollectionUtils;
import org.springframework.webflow.UnmodifiableAttributeMap;

public final class Event
extends EventObject {
    private final String id;
    private final long timestamp = System.currentTimeMillis();
    private final UnmodifiableAttributeMap attributes;

    public Event(Object source, String id) {
        this(source, id, CollectionUtils.EMPTY_ATTRIBUTE_MAP);
    }

    public Event(Object source, String id, AttributeCollection attributes) {
        super(source);
        Assert.hasText((String)id, (String)"The event id is required: please set this event's id to a non-blank string identifier");
        this.id = id;
        this.attributes = attributes != null ? attributes.unmodifiable() : CollectionUtils.EMPTY_ATTRIBUTE_MAP;
    }

    public String getId() {
        return this.id;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public UnmodifiableAttributeMap getAttributes() {
        return this.attributes;
    }

    public String toString() {
        return this.getId();
    }
}

