/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow;

import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.binding.mapping.AttributeMapper;
import org.springframework.core.CollectionFactory;
import org.springframework.core.style.StylerUtils;
import org.springframework.core.style.ToStringCreator;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.webflow.ActionList;
import org.springframework.webflow.AnnotatedObject;
import org.springframework.webflow.AttributeMap;
import org.springframework.webflow.FlowExecutionException;
import org.springframework.webflow.FlowExecutionExceptionHandlerSet;
import org.springframework.webflow.FlowVariable;
import org.springframework.webflow.NoMatchingTransitionException;
import org.springframework.webflow.RequestContext;
import org.springframework.webflow.RequestControlContext;
import org.springframework.webflow.State;
import org.springframework.webflow.Transition;
import org.springframework.webflow.TransitionSet;
import org.springframework.webflow.TransitionableState;
import org.springframework.webflow.ViewSelection;

public class Flow
extends AnnotatedObject {
    private static final Log logger = LogFactory.getLog((Class)(class$org$springframework$webflow$Flow == null ? (class$org$springframework$webflow$Flow = Flow.class$("org.springframework.webflow.Flow")) : class$org$springframework$webflow$Flow));
    private String id;
    private Set states = CollectionFactory.createLinkedSetIfPossible((int)9);
    private State startState;
    private Set variables = CollectionFactory.createLinkedSetIfPossible((int)3);
    private AttributeMapper inputMapper;
    private ActionList startActionList = new ActionList();
    private TransitionSet globalTransitionSet = new TransitionSet();
    private ActionList endActionList = new ActionList();
    private AttributeMapper outputMapper;
    private FlowExecutionExceptionHandlerSet exceptionHandlerSet = new FlowExecutionExceptionHandlerSet();
    private Set inlineFlows = CollectionFactory.createLinkedSetIfPossible((int)3);
    static /* synthetic */ Class class$org$springframework$webflow$Flow;

    public Flow(String id) {
        this.setId(id);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        Assert.hasText((String)id, (String)"This flow must have a unique, non-blank identifier");
        this.id = id;
    }

    protected void add(State state) throws IllegalArgumentException {
        if (this != state.getFlow() && state.getFlow() != null) {
            throw new IllegalArgumentException("State " + state + " cannot be added to this flow '" + this.getId() + "' -- it already belongs to a different flow: '" + state.getFlow().getId() + "'");
        }
        if (this.states.contains(state)) {
            throw new IllegalArgumentException("This flow '" + this.getId() + "' already contains a state with id '" + state.getId() + "' -- state ids must be locally unique to the flow definition; " + "existing state-ids of this flow include: " + StylerUtils.style((Object)this.getStateIds()));
        }
        boolean firstAdd = this.states.isEmpty();
        this.states.add(state);
        if (firstAdd) {
            this.setStartState(state);
        }
    }

    public int getStateCount() {
        return this.states.size();
    }

    public State[] getStates() {
        return this.states.toArray(new State[this.states.size()]);
    }

    public State getStartState() throws IllegalStateException {
        if (this.startState == null) {
            throw new IllegalStateException("No start state has been set for this flow ('" + this.getId() + "') -- flow builder configuration error?");
        }
        return this.startState;
    }

    public void setStartState(String stateId) throws IllegalArgumentException {
        this.setStartState(this.getRequiredState(stateId));
    }

    public void setStartState(State state) throws IllegalArgumentException {
        if (!this.states.contains(state)) {
            throw new IllegalArgumentException("State '" + state + "' is not a state of flow '" + this.getId() + "'");
        }
        this.startState = state;
    }

    public boolean containsState(String stateId) {
        return this.getState(stateId) != null;
    }

    public State getState(String stateId) {
        if (!StringUtils.hasText((String)stateId)) {
            throw new IllegalArgumentException("The specified stateId is invalid: state identifiers must be non-blank");
        }
        Iterator it = this.states.iterator();
        while (it.hasNext()) {
            State state = (State)it.next();
            if (!state.getId().equals(stateId)) continue;
            return state;
        }
        return null;
    }

    public State getRequiredState(String stateId) throws IllegalArgumentException {
        State state = this.getState(stateId);
        if (state == null) {
            throw new IllegalArgumentException("Cannot find state with id '" + stateId + "' in flow '" + this.getId() + "' -- " + "Known state ids are '" + this.getStateIds() + "'");
        }
        return state;
    }

    public TransitionableState getTransitionableState(String stateId) throws ClassCastException {
        State state = this.getState(stateId);
        if (state != null && !(state instanceof TransitionableState)) {
            throw new ClassCastException("The state '" + stateId + "' of flow '" + this.getId() + "' must be transitionable");
        }
        return (TransitionableState)state;
    }

    public TransitionableState getRequiredTransitionableState(String stateId) throws ClassCastException, IllegalArgumentException {
        TransitionableState state = this.getTransitionableState(stateId);
        if (state == null) {
            throw new IllegalArgumentException("Cannot find state with id '" + stateId + "' in flow '" + this.getId() + "' -- " + "Known state ids are '" + this.getStateIds() + "'");
        }
        return state;
    }

    public String[] getStateIds() {
        String[] stateIds = new String[this.getStateCount()];
        int i = 0;
        Iterator it = this.states.iterator();
        while (it.hasNext()) {
            stateIds[i++] = ((State)it.next()).getId();
        }
        return stateIds;
    }

    public void addVariable(FlowVariable variable) {
        this.variables.add(variable);
    }

    public void addVariables(FlowVariable[] variables) {
        if (variables == null) {
            return;
        }
        for (int i = 0; i < variables.length; ++i) {
            this.addVariable(variables[i]);
        }
    }

    public FlowVariable[] getVariables() {
        return this.variables.toArray(new FlowVariable[this.variables.size()]);
    }

    public AttributeMapper getInputMapper() {
        return this.inputMapper;
    }

    public void setInputMapper(AttributeMapper inputMapper) {
        this.inputMapper = inputMapper;
    }

    public ActionList getStartActionList() {
        return this.startActionList;
    }

    public ActionList getEndActionList() {
        return this.endActionList;
    }

    public AttributeMapper getOutputMapper() {
        return this.outputMapper;
    }

    public void setOutputMapper(AttributeMapper outputMapper) {
        this.outputMapper = outputMapper;
    }

    public FlowExecutionExceptionHandlerSet getExceptionHandlerSet() {
        return this.exceptionHandlerSet;
    }

    public void addInlineFlow(Flow flow) {
        this.inlineFlows.add(flow);
    }

    public String[] getInlineFlowIds() {
        String[] flowIds = new String[this.getInlineFlowCount()];
        int i = 0;
        Iterator it = this.inlineFlows.iterator();
        while (it.hasNext()) {
            flowIds[i++] = ((Flow)it.next()).getId();
        }
        return flowIds;
    }

    public Flow[] getInlineFlows() {
        return this.inlineFlows.toArray(new Flow[this.inlineFlows.size()]);
    }

    public int getInlineFlowCount() {
        return this.inlineFlows.size();
    }

    public boolean containsInlineFlow(String id) {
        return this.getInlineFlow(id) != null;
    }

    public Flow getInlineFlow(String id) throws IllegalArgumentException {
        if (!StringUtils.hasText((String)id)) {
            throw new IllegalArgumentException("The specified inline flowId is invalid: flow identifiers must be non-blank");
        }
        Iterator it = this.inlineFlows.iterator();
        while (it.hasNext()) {
            Flow flow = (Flow)it.next();
            if (!flow.getId().equals(id)) continue;
            return flow;
        }
        return null;
    }

    public TransitionSet getGlobalTransitionSet() {
        return this.globalTransitionSet;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Flow)) {
            return false;
        }
        Flow other = (Flow)o;
        return this.id.equals(other.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public ViewSelection start(RequestControlContext context, AttributeMap input) throws FlowExecutionException {
        this.createVariables(context);
        if (this.inputMapper != null) {
            this.inputMapper.map((Object)input, (Object)context, Collections.EMPTY_MAP);
        }
        this.startActionList.execute(context);
        return this.startState.enter(context);
    }

    public ViewSelection onEvent(RequestControlContext context) throws FlowExecutionException {
        TransitionableState currentState = this.getCurrentTransitionableState(context);
        try {
            return currentState.onEvent(context);
        }
        catch (NoMatchingTransitionException e) {
            Transition transition = this.globalTransitionSet.getTransition(context);
            if (transition != null) {
                return transition.execute(currentState, context);
            }
            throw e;
        }
    }

    public void end(RequestControlContext context, AttributeMap output) throws FlowExecutionException {
        this.endActionList.execute(context);
        if (this.outputMapper != null) {
            this.outputMapper.map((Object)context, (Object)output, Collections.EMPTY_MAP);
        }
    }

    public ViewSelection handleException(FlowExecutionException exception, RequestControlContext context) throws FlowExecutionException {
        return this.getExceptionHandlerSet().handleException(exception, context);
    }

    private void createVariables(RequestContext context) {
        Iterator it = this.variables.iterator();
        while (it.hasNext()) {
            FlowVariable variable = (FlowVariable)it.next();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Creating " + variable));
            }
            variable.create(context);
        }
    }

    private TransitionableState getCurrentTransitionableState(RequestControlContext context) {
        State currentState = context.getCurrentState();
        if (!(currentState instanceof TransitionableState)) {
            throw new IllegalStateException("You can only signal events in transitionable states, and state " + context.getCurrentState() + " is not transitionable - programmer error");
        }
        return (TransitionableState)currentState;
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("id", (Object)this.id).append("states", (Object)this.states).append("startState", (Object)this.startState).append("variables", (Object)this.variables).append("inputMapper", (Object)this.inputMapper).append("startActionList", (Object)this.startActionList).append("exceptionHandlerSet", (Object)this.exceptionHandlerSet).append("globalTransitionSet", (Object)this.globalTransitionSet).append("endActionList", (Object)this.endActionList).append("outputMapper", (Object)this.outputMapper).append("inlineFlows", (Object)this.inlineFlows).toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

