/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.springframework.core.style.StylerUtils;
import org.springframework.webflow.CollectionUtils;
import org.springframework.webflow.FlowExecutionException;
import org.springframework.webflow.FlowExecutionExceptionHandler;
import org.springframework.webflow.RequestControlContext;
import org.springframework.webflow.ViewSelection;

public class FlowExecutionExceptionHandlerSet {
    private List exceptionHandlers = new LinkedList();

    public boolean add(FlowExecutionExceptionHandler exceptionHandler) {
        if (this.contains(exceptionHandler)) {
            return false;
        }
        return this.exceptionHandlers.add(exceptionHandler);
    }

    public boolean addAll(FlowExecutionExceptionHandler[] exceptionHandlers) {
        return CollectionUtils.addAllNoDuplicates(this.exceptionHandlers, exceptionHandlers);
    }

    public boolean contains(FlowExecutionExceptionHandler exceptionHandler) {
        return this.exceptionHandlers.contains(exceptionHandler);
    }

    public boolean remove(FlowExecutionExceptionHandler exceptionHandler) {
        return this.exceptionHandlers.remove(exceptionHandler);
    }

    public int size() {
        return this.exceptionHandlers.size();
    }

    public FlowExecutionExceptionHandler[] toArray() {
        return this.exceptionHandlers.toArray(new FlowExecutionExceptionHandler[this.exceptionHandlers.size()]);
    }

    public ViewSelection handleException(FlowExecutionException exception, RequestControlContext context) {
        Iterator it = this.exceptionHandlers.iterator();
        while (it.hasNext()) {
            ViewSelection result;
            FlowExecutionExceptionHandler handler = (FlowExecutionExceptionHandler)it.next();
            if (!handler.handles(exception) || (result = handler.handle(exception, context)) == null) continue;
            return result;
        }
        return null;
    }

    public String toString() {
        return StylerUtils.style((Object)this.exceptionHandlers);
    }
}

