/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.style.ToStringCreator;
import org.springframework.util.Assert;
import org.springframework.webflow.AnnotatedObject;
import org.springframework.webflow.FlowExecutionException;
import org.springframework.webflow.RequestContext;
import org.springframework.webflow.RequestControlContext;
import org.springframework.webflow.State;
import org.springframework.webflow.TargetStateResolver;
import org.springframework.webflow.TransitionCriteria;
import org.springframework.webflow.TransitionableState;
import org.springframework.webflow.ViewSelection;
import org.springframework.webflow.WildcardTransitionCriteria;

public class Transition
extends AnnotatedObject {
    protected final Log logger = LogFactory.getLog((Class)(class$org$springframework$webflow$Transition == null ? (class$org$springframework$webflow$Transition = Transition.class$("org.springframework.webflow.Transition")) : class$org$springframework$webflow$Transition));
    private TransitionCriteria matchingCriteria = WildcardTransitionCriteria.INSTANCE;
    private TransitionCriteria executionCriteria = WildcardTransitionCriteria.INSTANCE;
    private TargetStateResolver targetStateResolver;
    static /* synthetic */ Class class$org$springframework$webflow$Transition;

    public Transition(TargetStateResolver targetStateResolver) {
        this.setTargetStateResolver(targetStateResolver);
    }

    public Transition(TransitionCriteria matchingCriteria, TargetStateResolver targetStateResolver) {
        this.setMatchingCriteria(matchingCriteria);
        this.setTargetStateResolver(targetStateResolver);
    }

    public TransitionCriteria getMatchingCriteria() {
        return this.matchingCriteria;
    }

    public void setMatchingCriteria(TransitionCriteria matchingCriteria) {
        Assert.notNull((Object)matchingCriteria, (String)"The matching criteria is required");
        this.matchingCriteria = matchingCriteria;
    }

    public TransitionCriteria getExecutionCriteria() {
        return this.executionCriteria;
    }

    public void setExecutionCriteria(TransitionCriteria executionCriteria) {
        this.executionCriteria = executionCriteria;
    }

    public TargetStateResolver getTargetStateResolver() {
        return this.targetStateResolver;
    }

    public void setTargetStateResolver(TargetStateResolver targetStateResolver) {
        Assert.notNull((Object)targetStateResolver, (String)"The target state resolver is required");
        this.targetStateResolver = targetStateResolver;
    }

    public boolean matches(RequestContext context) {
        return this.getMatchingCriteria().test(context);
    }

    public boolean canExecute(RequestContext context) {
        return this.getExecutionCriteria() != null ? this.getExecutionCriteria().test(context) : true;
    }

    protected State getTargetState(TransitionableState sourceState, RequestContext context) {
        return this.getTargetStateResolver().resolveTargetState(this, sourceState, context);
    }

    public ViewSelection execute(TransitionableState sourceState, RequestControlContext context) throws FlowExecutionException {
        ViewSelection selectedView;
        if (this.canExecute(context)) {
            if (sourceState != null) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Executing " + this + " out of state '" + sourceState.getId() + "'"));
                }
                sourceState.exit(context);
            } else if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Executing " + this));
            }
            State targetState = this.getTargetState(sourceState, context);
            context.setLastTransition(this);
            selectedView = targetState.enter(context);
        } else if (sourceState != null) {
            selectedView = sourceState.reenter(context);
        } else {
            throw new IllegalStateException("Execution of '" + this + "' was blocked by '" + this.getExecutionCriteria() + "', " + "; however, no source state is set at runtime.  " + "This is an illegal situation: check your flow definition.");
        }
        if (this.logger.isDebugEnabled()) {
            if (context.getFlowExecutionContext().isActive()) {
                this.logger.debug((Object)("Completed execution of " + this + ", as a result the new state is '" + context.getCurrentState().getId() + "' in flow '" + context.getActiveFlow().getId() + "'"));
            } else {
                this.logger.debug((Object)("Completed execution of " + this + ", as a result the flow execution has ended"));
            }
        }
        return selectedView;
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("matchingCriteria", (Object)this.getMatchingCriteria()).append("executionCriteria", (Object)this.getExecutionCriteria()).append("targetStateResolver", (Object)this.getTargetStateResolver()).append("attributes", (Object)this.getAttributeMap()).toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

