/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow;

import org.springframework.core.style.StylerUtils;
import org.springframework.core.style.ToStringCreator;
import org.springframework.webflow.ActionList;
import org.springframework.webflow.Flow;
import org.springframework.webflow.NoMatchingTransitionException;
import org.springframework.webflow.RequestContext;
import org.springframework.webflow.RequestControlContext;
import org.springframework.webflow.State;
import org.springframework.webflow.Transition;
import org.springframework.webflow.TransitionSet;
import org.springframework.webflow.ViewSelection;

public abstract class TransitionableState
extends State {
    private TransitionSet transitions = new TransitionSet();
    private ActionList exitActionList = new ActionList();

    protected TransitionableState(Flow flow, String id) throws IllegalArgumentException {
        super(flow, id);
    }

    public TransitionSet getTransitionSet() {
        return this.transitions;
    }

    public Transition getRequiredTransition(RequestContext context) throws NoMatchingTransitionException {
        Transition transition = this.getTransitionSet().getTransition(context);
        if (transition == null) {
            throw new NoMatchingTransitionException(this.getFlow().getId(), this.getId(), context.getLastEvent(), "No transition found on occurence of event '" + context.getLastEvent() + "' in state '" + this.getId() + "' of flow '" + this.getFlow().getId() + "' -- valid transitional criteria are " + StylerUtils.style((Object)this.getTransitionSet().getTransitionCriterias()) + " -- likely programmer error, check the set of TransitionCriteria for this state");
        }
        return transition;
    }

    public ActionList getExitActionList() {
        return this.exitActionList;
    }

    public ViewSelection onEvent(RequestControlContext context) throws NoMatchingTransitionException {
        return this.getRequiredTransition(context).execute(this, context);
    }

    public ViewSelection reenter(RequestControlContext context) {
        return this.enter(context);
    }

    public void exit(RequestControlContext context) {
        this.exitActionList.execute(context);
    }

    protected void appendToString(ToStringCreator creator) {
        creator.append("transitions", (Object)this.transitions).append("exitActionList", (Object)this.exitActionList);
    }
}

