/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow;

import org.springframework.core.style.ToStringCreator;
import org.springframework.util.Assert;
import org.springframework.webflow.Flow;
import org.springframework.webflow.FlowExecutionException;
import org.springframework.webflow.NullViewSelector;
import org.springframework.webflow.RequestContext;
import org.springframework.webflow.RequestControlContext;
import org.springframework.webflow.TransitionableState;
import org.springframework.webflow.ViewSelection;
import org.springframework.webflow.ViewSelector;

public class ViewState
extends TransitionableState {
    private ViewSelector viewSelector = NullViewSelector.INSTANCE;

    public ViewState(Flow flow, String id) throws IllegalArgumentException {
        super(flow, id);
    }

    public ViewSelector getViewSelector() {
        return this.viewSelector;
    }

    public void setViewSelector(ViewSelector viewSelector) {
        Assert.notNull((Object)viewSelector, (String)"The view selector to make view selections is required");
        this.viewSelector = viewSelector;
    }

    protected ViewSelection doEnter(RequestControlContext context) throws FlowExecutionException {
        return this.viewSelector.makeSelection(context);
    }

    public ViewSelection refresh(RequestContext context) throws FlowExecutionException {
        return this.viewSelector.makeRefreshSelection(context);
    }

    protected void appendToString(ToStringCreator creator) {
        creator.append("viewSelector", (Object)this.viewSelector);
        super.appendToString(creator);
    }
}

