/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.action;

import org.springframework.binding.convert.ConversionService;
import org.springframework.binding.method.MethodInvoker;
import org.springframework.binding.method.MethodSignature;
import org.springframework.util.Assert;
import org.springframework.webflow.Event;
import org.springframework.webflow.RequestContext;
import org.springframework.webflow.action.AbstractAction;
import org.springframework.webflow.action.BeanStatePersister;
import org.springframework.webflow.action.MethodResultSpecification;
import org.springframework.webflow.action.ResultEventFactory;
import org.springframework.webflow.action.SuccessEventFactory;

public abstract class AbstractBeanInvokingAction
extends AbstractAction {
    private MethodSignature methodSignature;
    private MethodInvoker methodInvoker = new MethodInvoker();
    private MethodResultSpecification methodResultSpecification;
    private ResultEventFactory resultEventFactory = new SuccessEventFactory();
    private BeanStatePersister beanStatePersister = new NoOpBeanStatePersister();

    protected AbstractBeanInvokingAction(MethodSignature methodSignature) {
        Assert.notNull((Object)methodSignature, (String)"The signature of the target method to invoke is required");
        this.methodSignature = methodSignature;
    }

    public MethodSignature getMethodSignature() {
        return this.methodSignature;
    }

    public MethodResultSpecification getMethodResultSpecification() {
        return this.methodResultSpecification;
    }

    public void setMethodResultSpecification(MethodResultSpecification resultSpecification) {
        this.methodResultSpecification = resultSpecification;
    }

    protected ResultEventFactory getResultEventFactory() {
        return this.resultEventFactory;
    }

    public void setResultEventFactory(ResultEventFactory resultEventFactory) {
        this.resultEventFactory = resultEventFactory;
    }

    protected BeanStatePersister getBeanStatePersister() {
        return this.beanStatePersister;
    }

    public void setBeanStatePersister(BeanStatePersister beanStatePersister) {
        this.beanStatePersister = beanStatePersister;
    }

    public void setConversionService(ConversionService conversionService) {
        this.methodInvoker.setConversionService(conversionService);
    }

    protected MethodInvoker getMethodInvoker() {
        return this.methodInvoker;
    }

    protected Event doExecute(RequestContext context) throws Exception {
        Object bean = this.getBeanStatePersister().restoreState(this.getBean(context), context);
        Object returnValue = this.getMethodInvoker().invoke(this.methodSignature, bean, (Object)context);
        if (this.methodResultSpecification != null) {
            this.methodResultSpecification.exposeResult(returnValue, context);
        }
        this.getBeanStatePersister().saveState(bean, context);
        return this.getResultEventFactory().createResultEvent(bean, returnValue, context);
    }

    protected abstract Object getBean(RequestContext var1) throws Exception;

    private static class NoOpBeanStatePersister
    implements BeanStatePersister {
        private NoOpBeanStatePersister() {
        }

        public void saveState(Object bean, RequestContext context) {
        }

        public Object restoreState(Object bean, RequestContext context) {
            return bean;
        }
    }
}

