/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.action;

import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyEditorRegistrar;
import org.springframework.beans.PropertyEditorRegistry;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.style.StylerUtils;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import org.springframework.validation.BindException;
import org.springframework.validation.DataBinder;
import org.springframework.validation.Errors;
import org.springframework.validation.MessageCodesResolver;
import org.springframework.validation.Validator;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.webflow.Event;
import org.springframework.webflow.RequestContext;
import org.springframework.webflow.ScopeType;
import org.springframework.webflow.action.FormObjectAccessor;
import org.springframework.webflow.action.MultiAction;
import org.springframework.webflow.util.DispatchMethodInvoker;

public class FormAction
extends MultiAction
implements InitializingBean {
    public static final String DEFAULT_FORM_OBJECT_NAME = "formObject";
    public static final String VALIDATOR_METHOD_ATTRIBUTE = "validatorMethod";
    private String formObjectName = "formObject";
    private Class formObjectClass;
    private ScopeType formObjectScope = ScopeType.FLOW;
    private ScopeType formErrorsScope = ScopeType.REQUEST;
    private PropertyEditorRegistrar propertyEditorRegistrar;
    private Validator validator;
    private MessageCodesResolver messageCodesResolver;
    private DispatchMethodInvoker validateMethodInvoker;
    static /* synthetic */ Class class$org$springframework$validation$Errors;

    public FormAction() {
    }

    public FormAction(Class formObjectClass) {
        this.setFormObjectClass(formObjectClass);
    }

    public String getFormObjectName() {
        return this.formObjectName;
    }

    public void setFormObjectName(String formObjectName) {
        this.formObjectName = formObjectName;
    }

    public Class getFormObjectClass() {
        return this.formObjectClass;
    }

    public void setFormObjectClass(Class formObjectClass) {
        this.formObjectClass = formObjectClass;
        if ((this.formObjectName == null || this.formObjectName == DEFAULT_FORM_OBJECT_NAME) && formObjectClass != null) {
            this.formObjectName = ClassUtils.getShortNameAsProperty((Class)formObjectClass);
        }
    }

    public ScopeType getFormObjectScope() {
        return this.formObjectScope;
    }

    public void setFormObjectScope(ScopeType scopeType) {
        this.formObjectScope = scopeType;
    }

    public ScopeType getFormErrorsScope() {
        return this.formErrorsScope;
    }

    public void setFormErrorsScope(ScopeType errorsScope) {
        this.formErrorsScope = errorsScope;
    }

    public PropertyEditorRegistrar getPropertyEditorRegistrar() {
        return this.propertyEditorRegistrar;
    }

    public void setPropertyEditorRegistrar(PropertyEditorRegistrar propertyEditorRegistrar) {
        this.propertyEditorRegistrar = propertyEditorRegistrar;
    }

    public Validator getValidator() {
        return this.validator;
    }

    public void setValidator(Validator validator) {
        this.validator = validator;
    }

    public MessageCodesResolver getMessageCodesResolver() {
        return this.messageCodesResolver;
    }

    public void setMessageCodesResolver(MessageCodesResolver messageCodesResolver) {
        this.messageCodesResolver = messageCodesResolver;
    }

    protected void initAction() {
        if (this.getValidator() != null) {
            if (this.getFormObjectClass() != null && !this.getValidator().supports(this.getFormObjectClass())) {
                throw new IllegalArgumentException("Validator [" + this.getValidator() + "] does not support form object class [" + this.getFormObjectClass() + "]");
            }
            Assert.notNull((Object)this.getFormObjectClass(), (String)"When using a validator, the form object class is required");
            this.validateMethodInvoker = new DispatchMethodInvoker(this.validator, new Class[]{this.getFormObjectClass(), class$org$springframework$validation$Errors == null ? (class$org$springframework$validation$Errors = FormAction.class$("org.springframework.validation.Errors")) : class$org$springframework$validation$Errors});
        }
    }

    public Event setupForm(RequestContext context) throws Exception {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Executing setupForm");
        }
        this.ensureFormErrorsExposed(context, this.getFormObject(context));
        return this.success();
    }

    public Event bindAndValidate(RequestContext context) throws Exception {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Executing bind");
        }
        Object formObject = this.getFormObject(context);
        DataBinder binder = this.createBinder(context, formObject);
        this.doBind(context, binder);
        this.setFormErrors(context, (Errors)binder.getErrors());
        if (this.getValidator() != null && this.validationEnabled(context)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Executing validate");
            }
            this.doValidate(context, binder);
        } else if (this.logger.isDebugEnabled()) {
            if (this.validator == null) {
                this.logger.debug((Object)"No validator is configured, no validation will occur after binding");
            } else {
                this.logger.debug((Object)"Validation was disabled for this bindAndValidate request");
            }
        }
        return binder.getErrors().hasErrors() ? this.error() : this.success();
    }

    public Event bind(RequestContext context) throws Exception {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Executing bind");
        }
        Object formObject = this.getFormObject(context);
        DataBinder binder = this.createBinder(context, formObject);
        this.doBind(context, binder);
        this.setFormErrors(context, (Errors)binder.getErrors());
        return binder.getErrors().hasErrors() ? this.error() : this.success();
    }

    public Event validate(RequestContext context) throws Exception {
        if (this.getValidator() != null && this.validationEnabled(context)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Executing validate");
            }
            Object formObject = this.getFormObject(context);
            DataBinder binder = this.createBinder(context, formObject);
            this.doValidate(context, binder);
            this.setFormErrors(context, (Errors)binder.getErrors());
            return binder.getErrors().hasErrors() ? this.error() : this.success();
        }
        if (this.logger.isDebugEnabled()) {
            if (this.validator == null) {
                this.logger.debug((Object)"No validator is configured, no validation will occur");
            } else {
                this.logger.debug((Object)"Validation was disabled for this request");
            }
        }
        return this.success();
    }

    public Event resetForm(RequestContext context) throws Exception {
        Object formObject = this.loadFormObject(context);
        this.setFormObject(context, formObject);
        this.setFormErrors(context, this.createFormErrors(context, formObject));
        return this.success();
    }

    protected DataBinder createBinder(RequestContext context, Object formObject) {
        WebDataBinder binder = new WebDataBinder(formObject, this.getFormObjectName());
        if (this.messageCodesResolver != null) {
            binder.setMessageCodesResolver(this.messageCodesResolver);
        }
        this.initBinder(context, (DataBinder)binder);
        return binder;
    }

    protected void doBind(RequestContext context, DataBinder binder) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Binding allowed request parameters in " + StylerUtils.style((Object)context.getExternalContext().getRequestParameterMap()) + " to form object with name '" + binder.getObjectName() + "', pre-bind formObject toString = " + binder.getTarget()));
            if (binder.getAllowedFields() != null && binder.getAllowedFields().length > 0) {
                this.logger.debug((Object)("(Allowed fields are " + StylerUtils.style((Object)binder.getAllowedFields()) + ")"));
            } else {
                this.logger.debug((Object)"(Any field is allowed)");
            }
        }
        binder.bind((PropertyValues)new MutablePropertyValues(context.getRequestParameters().getMap()));
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Binding completed for form object with name '" + binder.getObjectName() + "', post-bind formObject toString = " + binder.getTarget()));
            this.logger.debug((Object)("There are [" + binder.getErrors().getErrorCount() + "] errors, details: " + binder.getErrors().getAllErrors()));
        }
    }

    protected void doValidate(RequestContext context, DataBinder binder) throws Exception {
        Assert.notNull((Object)this.validator, (String)"The validator must not be null when attempting validation -- programmer error");
        String validatorMethodName = context.getAttributes().getString(VALIDATOR_METHOD_ATTRIBUTE);
        if (StringUtils.hasText((String)validatorMethodName)) {
            this.invokeValidatorMethod(validatorMethodName, binder.getTarget(), (Errors)binder.getErrors());
        } else {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Invoking validator " + this.validator));
            }
            this.getValidator().validate(binder.getTarget(), (Errors)binder.getErrors());
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Validation completed for form object with name '" + binder.getObjectName() + "'"));
            this.logger.debug((Object)("There are [" + binder.getErrors().getErrorCount() + "] errors, details: " + binder.getErrors().getAllErrors()));
        }
    }

    private void invokeValidatorMethod(String validatorMethod, Object formObject, Errors errors) throws Exception {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Invoking piecemeal validator method '" + validatorMethod + "(" + this.getFormObjectClass() + ", Errors)'"));
        }
        this.getValidateMethodInvoker().invoke(validatorMethod, new Object[]{formObject, errors});
    }

    protected Object getFormObject(RequestContext context) throws Exception {
        FormObjectAccessor accessor = this.getFormObjectAccessor(context);
        Object formObject = accessor.getFormObject(this.getFormObjectName(), this.getFormObjectClass(), this.getFormObjectScope());
        if (formObject == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Loading new form object");
            }
            formObject = this.loadFormObject(context);
            this.setFormObject(context, formObject);
        } else {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Found existing form object with name '" + this.getFormObjectName() + "' of type [" + formObject.getClass() + "] in scope " + (Object)((Object)this.getFormObjectScope())));
            }
            accessor.setCurrentFormObject(formObject, this.getFormObjectScope());
        }
        return formObject;
    }

    private void setFormObject(RequestContext context, Object formObject) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Setting form object of type [" + formObject.getClass() + "] in scope " + (Object)((Object)this.getFormObjectScope()) + " with name '" + this.getFormObjectName() + "'"));
        }
        this.getFormObjectAccessor(context).setFormObject(formObject, this.getFormObjectName(), this.getFormObjectScope());
    }

    protected Errors getFormErrors(RequestContext context) throws Exception {
        return this.ensureFormErrorsExposed(context, this.getFormObject(context));
    }

    private Errors ensureFormErrorsExposed(RequestContext context, Object formObject) {
        BindException be;
        Errors errors = this.getFormObjectAccessor(context).getFormErrors(this.getFormObjectName(), this.getFormErrorsScope());
        if (errors instanceof BindException && (be = (BindException)errors).getTarget() != formObject) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Inconsistency detected: the Errors instance in '" + (Object)((Object)this.getFormErrorsScope()) + "' does NOT wrap the current form object " + formObject + " of class " + formObject.getClass() + "; instead this Errors instance unexpectedly wraps the target object " + be.getTarget() + " of class: " + be.getTarget().getClass() + ". " + "[Taking corrective action: overwriting the existing Errors instance with " + "an empty one for the current form object]"));
            }
            errors = null;
        }
        if (errors == null) {
            errors = this.createFormErrors(context, formObject);
            this.setFormErrors(context, errors);
        }
        return errors;
    }

    private Errors createFormErrors(RequestContext context, Object formObject) {
        return this.createBinder(context, formObject).getErrors();
    }

    private void setFormErrors(RequestContext context, Errors errors) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Setting form errors instance in scope " + (Object)((Object)this.getFormErrorsScope())));
        }
        this.getFormObjectAccessor(context).setFormErrors(errors, this.getFormErrorsScope());
    }

    protected DispatchMethodInvoker getValidateMethodInvoker() {
        return this.validateMethodInvoker;
    }

    protected FormObjectAccessor getFormObjectAccessor(RequestContext context) {
        return new FormObjectAccessor(context);
    }

    protected Object loadFormObject(RequestContext context) throws Exception {
        return this.createFormObject(context);
    }

    protected Object createFormObject(RequestContext context) throws Exception {
        if (this.formObjectClass == null) {
            throw new IllegalStateException("Cannot create form object without formObjectClass being set -- either set formObjectClass or override this method");
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Creating new instance of form object class [" + this.formObjectClass + "]"));
        }
        return this.formObjectClass.newInstance();
    }

    protected void initBinder(RequestContext context, DataBinder binder) {
        if (this.propertyEditorRegistrar != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Installing custom property editors");
            }
            this.propertyEditorRegistrar.registerCustomEditors((PropertyEditorRegistry)binder);
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"No property editor registrar set, no custom editors to register");
        }
    }

    protected boolean validationEnabled(RequestContext context) {
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

