/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.action;

import org.springframework.util.Assert;
import org.springframework.webflow.RequestContext;
import org.springframework.webflow.ScopeType;
import org.springframework.webflow.action.BeanStatePersister;
import org.springframework.webflow.action.Memento;
import org.springframework.webflow.action.MementoOriginator;

public class MementoBeanStatePersister
implements BeanStatePersister {
    private static final String BEAN_CONTEXT_ATTRIBUTE = "bean";
    private ScopeType scope = ScopeType.FLOW;
    static /* synthetic */ Class class$org$springframework$webflow$action$MementoOriginator;

    public ScopeType getScope() {
        return this.scope;
    }

    public void setScope(ScopeType scope) {
        this.scope = scope;
    }

    public void saveState(Object bean, RequestContext context) {
        this.assertIsMementoOriginator(bean);
        this.getScope().getScope(context).put(this.getAttributeName(context), ((MementoOriginator)bean).createMemento());
    }

    public Object restoreState(Object bean, RequestContext context) {
        this.assertIsMementoOriginator(bean);
        Memento memento = (Memento)this.getScope().getScope(context).getRequired(this.getAttributeName(context));
        ((MementoOriginator)bean).setMemento(memento);
        return bean;
    }

    private void assertIsMementoOriginator(Object bean) {
        Assert.isInstanceOf((Class)(class$org$springframework$webflow$action$MementoOriginator == null ? (class$org$springframework$webflow$action$MementoOriginator = MementoBeanStatePersister.class$("org.springframework.webflow.action.MementoOriginator")) : class$org$springframework$webflow$action$MementoOriginator), (Object)bean, (String)"MementoBeanStatePersister requires the persisted bean to be a MementoOriginator");
    }

    protected String getAttributeName(RequestContext context) {
        return "memento." + context.getAttributes().getRequiredString(BEAN_CONTEXT_ATTRIBUTE);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

