/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.action;

import org.springframework.core.style.ToStringCreator;
import org.springframework.util.Assert;
import org.springframework.webflow.RequestContext;
import org.springframework.webflow.ScopeType;

public class MethodResultSpecification {
    private String resultName;
    private ScopeType resultScope;

    public MethodResultSpecification(String resultName, ScopeType resultScope) {
        Assert.notNull((Object)resultName, (String)"The result name is required");
        Assert.notNull((Object)((Object)resultScope), (String)"The result scope is required");
        this.resultName = resultName;
        this.resultScope = resultScope;
    }

    public String getResultName() {
        return this.resultName;
    }

    public ScopeType getResultScope() {
        return this.resultScope;
    }

    public void exposeResult(Object returnValue, RequestContext context) {
        this.resultScope.getScope(context).put(this.resultName, returnValue);
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("resultName", (Object)this.resultName).append("resultScope", (Object)this.resultScope).toString();
    }
}

