/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.action;

import org.springframework.beans.factory.BeanFactory;
import org.springframework.binding.method.MethodSignature;
import org.springframework.util.Assert;
import org.springframework.webflow.RequestContext;
import org.springframework.webflow.ScopeType;
import org.springframework.webflow.action.BeanFactoryBeanInvokingAction;
import org.springframework.webflow.action.BeanStatePersister;

public class StatefulBeanInvokingAction
extends BeanFactoryBeanInvokingAction {
    private ScopeType beanScope = ScopeType.FLOW;

    public StatefulBeanInvokingAction(MethodSignature methodSignature, String beanName, BeanFactory beanFactory) {
        super(methodSignature, beanName, beanFactory);
        this.setBeanStatePersister(new ScopeBeanStatePersister());
    }

    public ScopeType getBeanScope() {
        return this.beanScope;
    }

    public void setBeanScope(ScopeType beanScope) {
        if (beanScope == null) {
            beanScope = ScopeType.FLOW;
        }
        this.beanScope = beanScope;
    }

    protected Object getBean(RequestContext context) throws Exception {
        return this.beanScope.getScope(context).get(this.getBeanName());
    }

    private class ScopeBeanStatePersister
    implements BeanStatePersister {
        private ScopeBeanStatePersister() {
        }

        public void saveState(Object bean, RequestContext context) {
            StatefulBeanInvokingAction.this.getBeanScope().getScope(context).put(StatefulBeanInvokingAction.this.getBeanName(), bean);
        }

        public Object restoreState(Object bean, RequestContext context) {
            if (bean == null) {
                return this.getPrototypeBean(StatefulBeanInvokingAction.this.getBeanName());
            }
            return bean;
        }

        private Object getPrototypeBean(String beanName) {
            Assert.isTrue((!StatefulBeanInvokingAction.this.getBeanFactory().isSingleton(beanName) ? 1 : 0) != 0, (String)("The definition of the stateful bean with name '" + beanName + "' must be a prototype"));
            return StatefulBeanInvokingAction.this.getBeanFactory().getBean(beanName);
        }
    }
}

