/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.builder;

import java.util.HashMap;
import org.springframework.binding.mapping.AttributeMapper;
import org.springframework.binding.mapping.MappingBuilder;
import org.springframework.binding.method.MethodSignature;
import org.springframework.webflow.Action;
import org.springframework.webflow.AnnotatedAction;
import org.springframework.webflow.AttributeCollection;
import org.springframework.webflow.CollectionUtils;
import org.springframework.webflow.Flow;
import org.springframework.webflow.FlowAttributeMapper;
import org.springframework.webflow.FlowExecutionExceptionHandler;
import org.springframework.webflow.ScopeType;
import org.springframework.webflow.State;
import org.springframework.webflow.TargetStateResolver;
import org.springframework.webflow.Transition;
import org.springframework.webflow.TransitionCriteria;
import org.springframework.webflow.ViewSelector;
import org.springframework.webflow.action.MethodResultSpecification;
import org.springframework.webflow.action.MultiAction;
import org.springframework.webflow.builder.BaseFlowBuilder;
import org.springframework.webflow.builder.BeanInvokingActionFactory;
import org.springframework.webflow.builder.FlowArtifactFactory;
import org.springframework.webflow.builder.FlowArtifactLookupException;
import org.springframework.webflow.builder.FlowBuilderException;
import org.springframework.webflow.builder.FlowServiceLocator;
import org.springframework.webflow.support.ActionTransitionCriteria;
import org.springframework.webflow.support.EventFactorySupport;

public abstract class AbstractFlowBuilder
extends BaseFlowBuilder {
    private EventFactorySupport eventFactorySupport = new EventFactorySupport();
    static /* synthetic */ Class class$org$springframework$webflow$ViewSelector;
    static /* synthetic */ Class class$org$springframework$binding$method$MethodSignature;
    static /* synthetic */ Class class$org$springframework$webflow$TransitionCriteria;
    static /* synthetic */ Class class$org$springframework$webflow$TargetStateResolver;

    protected AbstractFlowBuilder() {
    }

    protected AbstractFlowBuilder(FlowServiceLocator flowServiceLocator) {
        super(flowServiceLocator);
    }

    public EventFactorySupport getEventFactorySupport() {
        return this.eventFactorySupport;
    }

    public void setEventFactorySupport(EventFactorySupport eventFactorySupport) {
        this.eventFactorySupport = eventFactorySupport;
    }

    public void init(String flowId, AttributeCollection attributes) throws FlowBuilderException {
        this.setFlow(this.getFlowArtifactFactory().createFlow(flowId, this.flowAttributes().union(attributes)));
    }

    protected AttributeCollection flowAttributes() {
        return CollectionUtils.EMPTY_ATTRIBUTE_MAP;
    }

    protected State addViewState(String stateId, String viewName, Transition transition) {
        return this.getFlowArtifactFactory().createViewState(stateId, this.getFlow(), null, this.viewSelector(viewName), new Transition[]{transition}, null, null, null);
    }

    protected State addViewState(String stateId, String viewName, Transition[] transitions) {
        return this.getFlowArtifactFactory().createViewState(stateId, this.getFlow(), null, this.viewSelector(viewName), transitions, null, null, null);
    }

    protected State addViewState(String stateId, Action[] entryActions, ViewSelector viewSelector, Transition[] transitions, FlowExecutionExceptionHandler[] exceptionHandlers, Action[] exitActions, AttributeCollection attributes) {
        return this.getFlowArtifactFactory().createViewState(stateId, this.getFlow(), entryActions, viewSelector, transitions, exceptionHandlers, exitActions, attributes);
    }

    protected State addActionState(String stateId, Action action, Transition transition) {
        return this.getFlowArtifactFactory().createActionState(stateId, this.getFlow(), null, new Action[]{action}, new Transition[]{transition}, null, null, null);
    }

    protected State addActionState(String stateId, Action action, Transition[] transitions) {
        return this.getFlowArtifactFactory().createActionState(stateId, this.getFlow(), null, new Action[]{action}, transitions, null, null, null);
    }

    protected State addActionState(String stateId, Action action, Transition transition, FlowExecutionExceptionHandler exceptionHandler) {
        return this.getFlowArtifactFactory().createActionState(stateId, this.getFlow(), null, new Action[]{action}, new Transition[]{transition}, new FlowExecutionExceptionHandler[]{exceptionHandler}, null, null);
    }

    protected State addActionState(String stateId, Action[] entryActions, Action[] actions, Transition[] transitions, FlowExecutionExceptionHandler[] exceptionHandlers, Action[] exitActions, AttributeCollection attributes) {
        return this.getFlowArtifactFactory().createActionState(stateId, this.getFlow(), entryActions, actions, transitions, exceptionHandlers, exitActions, attributes);
    }

    protected State addDecisionState(String stateId, TransitionCriteria decisionCriteria, TargetStateResolver trueStateResolver, TargetStateResolver falseStateResolver) {
        Transition thenTransition = this.getFlowArtifactFactory().createTransition(decisionCriteria, null, trueStateResolver, null);
        Transition elseTransition = this.getFlowArtifactFactory().createTransition(null, null, falseStateResolver, null);
        return this.getFlowArtifactFactory().createDecisionState(stateId, this.getFlow(), null, new Transition[]{thenTransition, elseTransition}, null, null, null);
    }

    protected State addDecisionState(String stateId, Transition[] transitions) {
        return this.getFlowArtifactFactory().createDecisionState(stateId, this.getFlow(), null, transitions, null, null, null);
    }

    protected State addDecisionState(String stateId, Action[] entryActions, Transition[] transitions, FlowExecutionExceptionHandler[] exceptionHandlers, Action[] exitActions, AttributeCollection attributes) {
        return this.getFlowArtifactFactory().createDecisionState(stateId, this.getFlow(), entryActions, transitions, exceptionHandlers, exitActions, attributes);
    }

    protected State addSubflowState(String stateId, Flow subflow, FlowAttributeMapper attributeMapper, Transition transition) {
        return this.getFlowArtifactFactory().createSubflowState(stateId, this.getFlow(), null, subflow, attributeMapper, new Transition[]{transition}, null, null, null);
    }

    protected State addSubflowState(String stateId, Flow subflow, FlowAttributeMapper attributeMapper, Transition[] transitions) {
        return this.getFlowArtifactFactory().createSubflowState(stateId, this.getFlow(), null, subflow, attributeMapper, transitions, null, null, null);
    }

    protected State addSubflowState(String stateId, Action[] entryActions, Flow subflow, FlowAttributeMapper attributeMapper, Transition[] transitions, FlowExecutionExceptionHandler[] exceptionHandlers, Action[] exitActions, AttributeCollection attributes) {
        return this.getFlowArtifactFactory().createSubflowState(stateId, this.getFlow(), entryActions, subflow, attributeMapper, transitions, exceptionHandlers, exitActions, attributes);
    }

    protected State addEndState(String stateId) {
        return this.getFlowArtifactFactory().createEndState(stateId, this.getFlow(), null, null, null, null, null);
    }

    protected State addEndState(String stateId, String viewName) {
        return this.getFlowArtifactFactory().createEndState(stateId, this.getFlow(), null, this.endingViewSelector(viewName), null, null, null);
    }

    protected State addEndState(String stateId, String viewName, AttributeMapper outputMapper) {
        return this.getFlowArtifactFactory().createEndState(stateId, this.getFlow(), null, this.endingViewSelector(viewName), outputMapper, null, null);
    }

    protected State addEndState(String stateId, Action[] entryActions, ViewSelector viewSelector, AttributeMapper outputMapper, FlowExecutionExceptionHandler[] exceptionHandlers, AttributeCollection attributes) {
        return this.getFlowArtifactFactory().createEndState(stateId, this.getFlow(), entryActions, viewSelector, outputMapper, exceptionHandlers, attributes);
    }

    protected ViewSelector viewSelector(String viewName) {
        return this.viewSelector("view", viewName);
    }

    protected ViewSelector endingViewSelector(String viewName) {
        return this.viewSelector("end", viewName);
    }

    private ViewSelector viewSelector(String stateType, String viewName) {
        HashMap<String, String> context = new HashMap<String, String>(1, 1.0f);
        context.put("stateType", stateType);
        return (ViewSelector)this.fromStringTo(class$org$springframework$webflow$ViewSelector == null ? (class$org$springframework$webflow$ViewSelector = AbstractFlowBuilder.class$("org.springframework.webflow.ViewSelector")) : class$org$springframework$webflow$ViewSelector).execute((Object)viewName, context);
    }

    protected Action action(String id) throws FlowArtifactLookupException {
        return this.getFlowServiceLocator().getAction(id);
    }

    protected Action action(String id, MethodSignature methodSignature) throws FlowArtifactLookupException {
        return this.getBeanInvokingActionFactory().createBeanInvokingAction(id, this.getFlowServiceLocator().getBeanFactory(), methodSignature, null, this.getFlowServiceLocator().getConversionService(), null);
    }

    protected Action action(String id, MethodSignature methodSignature, MethodResultSpecification resultSpecification) throws FlowArtifactLookupException {
        return this.getBeanInvokingActionFactory().createBeanInvokingAction(id, this.getFlowServiceLocator().getBeanFactory(), methodSignature, resultSpecification, this.getFlowServiceLocator().getConversionService(), null);
    }

    protected MethodSignature method(String method) {
        return (MethodSignature)this.fromStringTo(class$org$springframework$binding$method$MethodSignature == null ? (class$org$springframework$binding$method$MethodSignature = AbstractFlowBuilder.class$("org.springframework.binding.method.MethodSignature")) : class$org$springframework$binding$method$MethodSignature).execute((Object)method);
    }

    protected MethodResultSpecification result(String resultName) {
        return this.result(resultName, null);
    }

    protected MethodResultSpecification result(String resultName, ScopeType resultScope) {
        return new MethodResultSpecification(resultName, resultScope);
    }

    protected AnnotatedAction invoke(String methodName, MultiAction multiAction) throws FlowArtifactLookupException {
        AnnotatedAction action = new AnnotatedAction(multiAction);
        action.getAttributeMap().put("method", methodName);
        return action;
    }

    protected FlowAttributeMapper attributeMapper(String id) throws FlowArtifactLookupException {
        return this.getFlowServiceLocator().getAttributeMapper(id);
    }

    protected Flow flow(String id) throws FlowArtifactLookupException {
        return this.getFlowServiceLocator().getSubflow(id);
    }

    protected TransitionCriteria on(String transitionCriteriaExpression) {
        return (TransitionCriteria)this.fromStringTo(class$org$springframework$webflow$TransitionCriteria == null ? (class$org$springframework$webflow$TransitionCriteria = AbstractFlowBuilder.class$("org.springframework.webflow.TransitionCriteria")) : class$org$springframework$webflow$TransitionCriteria).execute((Object)transitionCriteriaExpression);
    }

    protected TargetStateResolver to(String targetStateExpression) {
        return (TargetStateResolver)this.fromStringTo(class$org$springframework$webflow$TargetStateResolver == null ? (class$org$springframework$webflow$TargetStateResolver = AbstractFlowBuilder.class$("org.springframework.webflow.TargetStateResolver")) : class$org$springframework$webflow$TargetStateResolver).execute((Object)targetStateExpression);
    }

    protected Transition transition(TransitionCriteria matchingCriteria, TargetStateResolver targetStateResolver) {
        return this.getFlowArtifactFactory().createTransition(matchingCriteria, null, targetStateResolver, null);
    }

    protected Transition transition(TransitionCriteria matchingCriteria, TargetStateResolver targetStateResolver, TransitionCriteria executionCriteria) {
        return this.getFlowArtifactFactory().createTransition(matchingCriteria, executionCriteria, targetStateResolver, null);
    }

    protected Transition transition(TransitionCriteria matchingCriteria, TargetStateResolver targetStateResolver, TransitionCriteria executionCriteria, AttributeCollection attributes) {
        return this.getFlowArtifactFactory().createTransition(matchingCriteria, executionCriteria, targetStateResolver, attributes);
    }

    protected TransitionCriteria ifReturnedSuccess(Action action) {
        return new ActionTransitionCriteria(action);
    }

    protected String success() {
        return this.eventFactorySupport.getSuccessEventId();
    }

    protected String error() {
        return this.eventFactorySupport.getErrorEventId();
    }

    protected String submit() {
        return "submit";
    }

    protected String back() {
        return "back";
    }

    protected String cancel() {
        return "cancel";
    }

    protected String finish() {
        return "finish";
    }

    protected String select() {
        return "select";
    }

    protected String edit() {
        return "edit";
    }

    protected String add() {
        return "add";
    }

    protected String delete() {
        return "delete";
    }

    protected String yes() {
        return this.eventFactorySupport.getYesEventId();
    }

    protected String no() {
        return this.eventFactorySupport.getNoEventId();
    }

    protected MappingBuilder mapping() {
        MappingBuilder mapping = new MappingBuilder(this.getFlowServiceLocator().getExpressionParser());
        mapping.setConversionService(this.getFlowServiceLocator().getConversionService());
        return mapping;
    }

    private FlowArtifactFactory getFlowArtifactFactory() {
        return this.getFlowServiceLocator().getFlowArtifactFactory();
    }

    private BeanInvokingActionFactory getBeanInvokingActionFactory() {
        return this.getFlowServiceLocator().getBeanInvokingActionFactory();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

