/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.builder;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.binding.convert.ConversionService;
import org.springframework.binding.convert.Converter;
import org.springframework.binding.convert.support.DefaultConversionService;
import org.springframework.binding.convert.support.GenericConversionService;
import org.springframework.binding.convert.support.TextToExpression;
import org.springframework.binding.expression.ExpressionParser;
import org.springframework.binding.method.TextToMethodSignature;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.Assert;
import org.springframework.webflow.Action;
import org.springframework.webflow.Flow;
import org.springframework.webflow.FlowAttributeMapper;
import org.springframework.webflow.FlowExecutionExceptionHandler;
import org.springframework.webflow.TargetStateResolver;
import org.springframework.webflow.TransitionCriteria;
import org.springframework.webflow.ViewSelector;
import org.springframework.webflow.builder.BeanInvokingActionFactory;
import org.springframework.webflow.builder.FlowArtifactFactory;
import org.springframework.webflow.builder.FlowArtifactLookupException;
import org.springframework.webflow.builder.FlowServiceLocator;
import org.springframework.webflow.builder.TextToTransitionCriteria;
import org.springframework.webflow.builder.TextToTransitionTargetStateResolver;
import org.springframework.webflow.builder.TextToViewSelector;
import org.springframework.webflow.support.DefaultExpressionParserFactory;

public class BaseFlowServiceLocator
implements FlowServiceLocator {
    private FlowArtifactFactory flowArtifactFactory = new FlowArtifactFactory();
    private BeanInvokingActionFactory beanInvokingActionFactory = new BeanInvokingActionFactory();
    private ExpressionParser expressionParser = new DefaultExpressionParserFactory().getExpressionParser();
    private ConversionService conversionService = this.createConversionService(null);
    private ResourceLoader resourceLoader = new DefaultResourceLoader();
    static /* synthetic */ Class class$org$springframework$webflow$Flow;
    static /* synthetic */ Class class$org$springframework$webflow$Action;
    static /* synthetic */ Class class$org$springframework$webflow$FlowAttributeMapper;
    static /* synthetic */ Class class$org$springframework$webflow$TransitionCriteria;
    static /* synthetic */ Class class$org$springframework$webflow$ViewSelector;
    static /* synthetic */ Class class$org$springframework$webflow$TargetStateResolver;
    static /* synthetic */ Class class$org$springframework$webflow$FlowExecutionExceptionHandler;

    public void setFlowArtifactFactory(FlowArtifactFactory flowArtifactFactory) {
        Assert.notNull((Object)flowArtifactFactory, (String)"The flow artifact factory is required");
        this.flowArtifactFactory = flowArtifactFactory;
    }

    public void setBeanInvokingActionFactory(BeanInvokingActionFactory beanInvokingActionFactory) {
        Assert.notNull((Object)beanInvokingActionFactory, (String)"The bean invoking action factory is required");
        this.beanInvokingActionFactory = beanInvokingActionFactory;
    }

    public void setExpressionParser(ExpressionParser expressionParser) {
        Assert.notNull((Object)expressionParser, (String)"The expression parser is required");
        this.expressionParser = expressionParser;
    }

    public void setConversionService(ConversionService conversionService) {
        Assert.notNull((Object)conversionService, (String)"The conversion service is required");
        this.conversionService = this.createConversionService(conversionService);
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public Flow getSubflow(String id) throws FlowArtifactLookupException {
        throw new FlowArtifactLookupException(id, class$org$springframework$webflow$Flow == null ? (class$org$springframework$webflow$Flow = BaseFlowServiceLocator.class$("org.springframework.webflow.Flow")) : class$org$springframework$webflow$Flow, "Subflow lookup is not supported by this artifact factory");
    }

    public Action getAction(String id) throws FlowArtifactLookupException {
        return (Action)this.getBean(id, class$org$springframework$webflow$Action == null ? (class$org$springframework$webflow$Action = BaseFlowServiceLocator.class$("org.springframework.webflow.Action")) : class$org$springframework$webflow$Action);
    }

    public boolean isAction(String actionId) throws FlowArtifactLookupException {
        return (class$org$springframework$webflow$Action == null ? (class$org$springframework$webflow$Action = BaseFlowServiceLocator.class$("org.springframework.webflow.Action")) : class$org$springframework$webflow$Action).isAssignableFrom(this.getBeanType(actionId, class$org$springframework$webflow$Action == null ? (class$org$springframework$webflow$Action = BaseFlowServiceLocator.class$("org.springframework.webflow.Action")) : class$org$springframework$webflow$Action));
    }

    public FlowAttributeMapper getAttributeMapper(String id) throws FlowArtifactLookupException {
        return (FlowAttributeMapper)this.getBean(id, class$org$springframework$webflow$FlowAttributeMapper == null ? (class$org$springframework$webflow$FlowAttributeMapper = BaseFlowServiceLocator.class$("org.springframework.webflow.FlowAttributeMapper")) : class$org$springframework$webflow$FlowAttributeMapper);
    }

    public TransitionCriteria getTransitionCriteria(String id) throws FlowArtifactLookupException {
        return (TransitionCriteria)this.getBean(id, class$org$springframework$webflow$TransitionCriteria == null ? (class$org$springframework$webflow$TransitionCriteria = BaseFlowServiceLocator.class$("org.springframework.webflow.TransitionCriteria")) : class$org$springframework$webflow$TransitionCriteria);
    }

    public ViewSelector getViewSelector(String id) throws FlowArtifactLookupException {
        return (ViewSelector)this.getBean(id, class$org$springframework$webflow$ViewSelector == null ? (class$org$springframework$webflow$ViewSelector = BaseFlowServiceLocator.class$("org.springframework.webflow.ViewSelector")) : class$org$springframework$webflow$ViewSelector);
    }

    public TargetStateResolver getTargetStateResolver(String id) throws FlowArtifactLookupException {
        return (TargetStateResolver)this.getBean(id, class$org$springframework$webflow$TargetStateResolver == null ? (class$org$springframework$webflow$TargetStateResolver = BaseFlowServiceLocator.class$("org.springframework.webflow.TargetStateResolver")) : class$org$springframework$webflow$TargetStateResolver);
    }

    public FlowExecutionExceptionHandler getExceptionHandler(String id) throws FlowArtifactLookupException {
        return (FlowExecutionExceptionHandler)this.getBean(id, class$org$springframework$webflow$FlowExecutionExceptionHandler == null ? (class$org$springframework$webflow$FlowExecutionExceptionHandler = BaseFlowServiceLocator.class$("org.springframework.webflow.FlowExecutionExceptionHandler")) : class$org$springframework$webflow$FlowExecutionExceptionHandler);
    }

    public FlowArtifactFactory getFlowArtifactFactory() {
        return this.flowArtifactFactory;
    }

    public BeanInvokingActionFactory getBeanInvokingActionFactory() {
        return this.beanInvokingActionFactory;
    }

    public ExpressionParser getExpressionParser() {
        return this.expressionParser;
    }

    public ConversionService getConversionService() {
        return this.conversionService;
    }

    public ResourceLoader getResourceLoader() throws UnsupportedOperationException {
        if (this.resourceLoader == null) {
            throw new UnsupportedOperationException("Resource loading is not supported by this service locator");
        }
        return this.resourceLoader;
    }

    public BeanFactory getBeanFactory() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Bean factory lookup is not supported by this service locator");
    }

    protected boolean containsBean(String id) {
        return this.getBeanFactory().containsBean(id);
    }

    protected Object getBean(String id, Class artifactType) throws FlowArtifactLookupException {
        try {
            return this.getBeanFactory().getBean(id, artifactType);
        }
        catch (BeansException e) {
            throw new FlowArtifactLookupException(id, artifactType, e);
        }
    }

    protected Class getBeanType(String id, Class artifactType) throws FlowArtifactLookupException {
        try {
            return this.getBeanFactory().getType(id);
        }
        catch (BeansException e) {
            throw new FlowArtifactLookupException(id, artifactType, e);
        }
    }

    protected ConversionService createConversionService(ConversionService parent) {
        if (parent != null) {
            GenericConversionService conversionService = new GenericConversionService();
            this.addWebFlowConverters(conversionService);
            conversionService.setParent(parent);
            return conversionService;
        }
        DefaultConversionService conversionService = new DefaultConversionService();
        this.addWebFlowConverters((GenericConversionService)conversionService);
        return conversionService;
    }

    protected void addWebFlowConverters(GenericConversionService conversionService) {
        conversionService.addConverter((Converter)new TextToTransitionCriteria(this));
        conversionService.addConverter((Converter)new TextToViewSelector(this));
        conversionService.addConverter((Converter)new TextToTransitionTargetStateResolver(this));
        conversionService.addConverter((Converter)new TextToExpression(this.getExpressionParser()));
        conversionService.addConverter((Converter)new TextToMethodSignature((ConversionService)conversionService));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

