/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.builder;

import org.springframework.binding.mapping.AttributeMapper;
import org.springframework.webflow.Action;
import org.springframework.webflow.ActionState;
import org.springframework.webflow.AttributeCollection;
import org.springframework.webflow.DecisionState;
import org.springframework.webflow.EndState;
import org.springframework.webflow.Flow;
import org.springframework.webflow.FlowAttributeMapper;
import org.springframework.webflow.FlowExecutionExceptionHandler;
import org.springframework.webflow.State;
import org.springframework.webflow.SubflowState;
import org.springframework.webflow.TargetStateResolver;
import org.springframework.webflow.Transition;
import org.springframework.webflow.TransitionCriteria;
import org.springframework.webflow.TransitionableState;
import org.springframework.webflow.ViewSelector;
import org.springframework.webflow.ViewState;
import org.springframework.webflow.builder.FlowArtifactLookupException;

public class FlowArtifactFactory {
    public Flow createFlow(String id, AttributeCollection attributes) throws FlowArtifactLookupException {
        Flow flow = new Flow(id);
        flow.getAttributeMap().putAll(attributes);
        return flow;
    }

    public State createViewState(String id, Flow flow, Action[] entryActions, ViewSelector viewSelector, Transition[] transitions, FlowExecutionExceptionHandler[] exceptionHandlers, Action[] exitActions, AttributeCollection attributes) throws FlowArtifactLookupException {
        ViewState viewState = new ViewState(flow, id);
        if (viewSelector != null) {
            viewState.setViewSelector(viewSelector);
        }
        this.configureCommonProperties(viewState, entryActions, transitions, exceptionHandlers, exitActions, attributes);
        return viewState;
    }

    public State createActionState(String id, Flow flow, Action[] entryActions, Action[] actions, Transition[] transitions, FlowExecutionExceptionHandler[] exceptionHandlers, Action[] exitActions, AttributeCollection attributes) throws FlowArtifactLookupException {
        ActionState actionState = new ActionState(flow, id);
        actionState.getActionList().addAll(actions);
        this.configureCommonProperties(actionState, entryActions, transitions, exceptionHandlers, exitActions, attributes);
        return actionState;
    }

    public State createDecisionState(String id, Flow flow, Action[] entryActions, Transition[] transitions, FlowExecutionExceptionHandler[] exceptionHandlers, Action[] exitActions, AttributeCollection attributes) throws FlowArtifactLookupException {
        DecisionState decisionState = new DecisionState(flow, id);
        this.configureCommonProperties(decisionState, entryActions, transitions, exceptionHandlers, exitActions, attributes);
        return decisionState;
    }

    public State createSubflowState(String id, Flow flow, Action[] entryActions, Flow subflow, FlowAttributeMapper attributeMapper, Transition[] transitions, FlowExecutionExceptionHandler[] exceptionHandlers, Action[] exitActions, AttributeCollection attributes) throws FlowArtifactLookupException {
        SubflowState subflowState = new SubflowState(flow, id, subflow);
        if (attributeMapper != null) {
            subflowState.setAttributeMapper(attributeMapper);
        }
        this.configureCommonProperties(subflowState, entryActions, transitions, exceptionHandlers, exitActions, attributes);
        return subflowState;
    }

    public State createEndState(String id, Flow flow, Action[] entryActions, ViewSelector viewSelector, AttributeMapper outputMapper, FlowExecutionExceptionHandler[] exceptionHandlers, AttributeCollection attributes) throws FlowArtifactLookupException {
        EndState endState = new EndState(flow, id);
        if (viewSelector != null) {
            endState.setViewSelector(viewSelector);
        }
        if (outputMapper != null) {
            endState.setOutputMapper(outputMapper);
        }
        this.configureCommonProperties(endState, entryActions, exceptionHandlers, attributes);
        return endState;
    }

    public Transition createTransition(TransitionCriteria matchingCriteria, TransitionCriteria executionCriteria, TargetStateResolver targetStateResolver, AttributeCollection attributes) throws FlowArtifactLookupException {
        Transition transition = new Transition(targetStateResolver);
        if (matchingCriteria != null) {
            transition.setMatchingCriteria(matchingCriteria);
        }
        if (executionCriteria != null) {
            transition.setExecutionCriteria(executionCriteria);
        }
        transition.getAttributeMap().putAll(attributes);
        return transition;
    }

    private void configureCommonProperties(TransitionableState state, Action[] entryActions, Transition[] transitions, FlowExecutionExceptionHandler[] exceptionHandlers, Action[] exitActions, AttributeCollection attributes) {
        this.configureCommonProperties(state, entryActions, exceptionHandlers, attributes);
        state.getTransitionSet().addAll(transitions);
        state.getExitActionList().addAll(exitActions);
    }

    private void configureCommonProperties(State state, Action[] entryActions, FlowExecutionExceptionHandler[] exceptionHandlers, AttributeCollection attributes) {
        state.getEntryActionList().addAll(entryActions);
        state.getExceptionHandlerSet().addAll(exceptionHandlers);
        state.getAttributeMap().putAll(attributes);
    }
}

