/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.builder;

import org.springframework.util.Assert;
import org.springframework.webflow.AttributeCollection;
import org.springframework.webflow.CollectionUtils;
import org.springframework.webflow.UnmodifiableAttributeMap;
import org.springframework.webflow.builder.FlowBuilder;
import org.springframework.webflow.builder.FlowBuilderException;

public class FlowAssembler {
    private String flowId;
    private UnmodifiableAttributeMap flowAttributes;
    private FlowBuilder flowBuilder;

    public FlowAssembler(String flowId, FlowBuilder flowBuilder) {
        this(flowId, null, flowBuilder);
    }

    public FlowAssembler(String flowId, AttributeCollection flowAttributes, FlowBuilder flowBuilder) {
        Assert.hasText((String)flowId, (String)"The flow id is required");
        Assert.notNull((Object)flowBuilder, (String)"The flow builder is required");
        this.flowId = flowId;
        this.flowAttributes = flowAttributes != null ? flowAttributes.unmodifiable() : CollectionUtils.EMPTY_ATTRIBUTE_MAP;
        this.flowBuilder = flowBuilder;
    }

    public String getFlowId() {
        return this.flowId;
    }

    public UnmodifiableAttributeMap getFlowAttributes() {
        return this.flowAttributes;
    }

    public FlowBuilder getFlowBuilder() {
        return this.flowBuilder;
    }

    public void assembleFlow() throws FlowBuilderException {
        this.flowBuilder.init(this.flowId, this.flowAttributes);
        this.flowBuilder.buildVariables();
        this.flowBuilder.buildStartActions();
        this.flowBuilder.buildInputMapper();
        this.flowBuilder.buildInlineFlows();
        this.flowBuilder.buildStates();
        this.flowBuilder.buildGlobalTransitions();
        this.flowBuilder.buildEndActions();
        this.flowBuilder.buildOutputMapper();
        this.flowBuilder.buildExceptionHandlers();
        this.flowBuilder.dispose();
    }
}

