/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.builder;

import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.GenericWebApplicationContext;
import org.springframework.webflow.Flow;
import org.springframework.webflow.builder.FlowServiceLocator;
import org.springframework.webflow.builder.LocalFlowServiceLocator;

class LocalFlowServiceRegistry {
    private Flow flow;
    private Resource[] resources;
    private GenericApplicationContext context;

    public LocalFlowServiceRegistry(Flow flow, Resource[] resources) {
        this.flow = flow;
        this.resources = resources;
    }

    public Flow getFlow() {
        return this.flow;
    }

    public Resource[] getResources() {
        return this.resources;
    }

    public ApplicationContext getContext() {
        return this.context;
    }

    public void init(LocalFlowServiceLocator localFactory, FlowServiceLocator rootFactory) {
        BeanFactory parent = null;
        if (localFactory.isEmpty()) {
            try {
                parent = rootFactory.getBeanFactory();
            }
            catch (UnsupportedOperationException e) {}
        } else {
            parent = localFactory.top().context;
        }
        this.context = this.createLocalFlowContext(parent, rootFactory);
        new XmlBeanDefinitionReader((BeanDefinitionRegistry)this.context).loadBeanDefinitions(this.resources);
        this.context.refresh();
    }

    private GenericApplicationContext createLocalFlowContext(BeanFactory parent, FlowServiceLocator rootFactory) {
        if (parent instanceof WebApplicationContext) {
            GenericWebApplicationContext context = new GenericWebApplicationContext();
            context.setServletContext(((WebApplicationContext)parent).getServletContext());
            context.setParent((ApplicationContext)((WebApplicationContext)parent));
            context.setResourceLoader(rootFactory.getResourceLoader());
            return context;
        }
        GenericApplicationContext context = new GenericApplicationContext();
        if (parent instanceof ApplicationContext) {
            context.setParent((ApplicationContext)parent);
        } else if (parent != null) {
            context.getBeanFactory().setParentBeanFactory(parent);
        }
        context.setResourceLoader(rootFactory.getResourceLoader());
        return context;
    }
}

