/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.builder;

import org.springframework.binding.convert.support.ConversionServiceAwareConverter;
import org.springframework.binding.expression.Expression;
import org.springframework.binding.util.MapAccessor;
import org.springframework.util.StringUtils;
import org.springframework.webflow.NullViewSelector;
import org.springframework.webflow.ViewSelector;
import org.springframework.webflow.builder.FlowServiceLocator;
import org.springframework.webflow.support.ApplicationViewSelector;
import org.springframework.webflow.support.ExternalRedirectSelector;
import org.springframework.webflow.support.FlowRedirectSelector;

public class TextToViewSelector
extends ConversionServiceAwareConverter {
    public static final String STATE_TYPE_CONTEXT_PARAMETER = "stateType";
    public static final String VIEW_STATE_TYPE = "view";
    public static final String END_STATE_TYPE = "end";
    public static final String REDIRECT_PREFIX = "redirect:";
    public static final String EXTERNAL_REDIRECT_PREFIX = "externalRedirect:";
    public static final String FLOW_REDIRECT_PREFIX = "flowRedirect:";
    private static final String BEAN_PREFIX = "bean:";
    private FlowServiceLocator flowServiceLocator;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$springframework$webflow$ViewSelector;
    static /* synthetic */ Class class$org$springframework$binding$expression$Expression;

    public TextToViewSelector(FlowServiceLocator flowServiceLocator) {
        this.flowServiceLocator = flowServiceLocator;
    }

    public Class[] getSourceClasses() {
        return new Class[]{class$java$lang$String == null ? (class$java$lang$String = TextToViewSelector.class$("java.lang.String")) : class$java$lang$String};
    }

    public Class[] getTargetClasses() {
        return new Class[]{class$org$springframework$webflow$ViewSelector == null ? (class$org$springframework$webflow$ViewSelector = TextToViewSelector.class$("org.springframework.webflow.ViewSelector")) : class$org$springframework$webflow$ViewSelector};
    }

    protected Object doConvert(Object source, Class targetClass, MapAccessor context) throws Exception {
        String encodedView = (String)source;
        if (!StringUtils.hasText((String)encodedView)) {
            return NullViewSelector.INSTANCE;
        }
        String stateType = context.getRequiredString((Object)STATE_TYPE_CONTEXT_PARAMETER);
        if (stateType.equals(VIEW_STATE_TYPE)) {
            return this.convertEncodedViewStateSelector(encodedView);
        }
        if (stateType.equals(END_STATE_TYPE)) {
            return this.convertEncodedEndStateSelector(encodedView);
        }
        throw new IllegalArgumentException("No state context provided; unable to convert encoded view selector '" + encodedView + "'");
    }

    protected ViewSelector convertEncodedViewStateSelector(String encodedView) {
        if (encodedView.startsWith(REDIRECT_PREFIX)) {
            String viewName = encodedView.substring(REDIRECT_PREFIX.length());
            Expression viewNameExpr = (Expression)this.fromStringTo(class$org$springframework$binding$expression$Expression == null ? (class$org$springframework$binding$expression$Expression = TextToViewSelector.class$("org.springframework.binding.expression.Expression")) : class$org$springframework$binding$expression$Expression).execute((Object)viewName);
            return new ApplicationViewSelector(viewNameExpr, true);
        }
        if (encodedView.startsWith(EXTERNAL_REDIRECT_PREFIX)) {
            String externalUrl = encodedView.substring(EXTERNAL_REDIRECT_PREFIX.length());
            Expression urlExpr = (Expression)this.fromStringTo(class$org$springframework$binding$expression$Expression == null ? (class$org$springframework$binding$expression$Expression = TextToViewSelector.class$("org.springframework.binding.expression.Expression")) : class$org$springframework$binding$expression$Expression).execute((Object)externalUrl);
            return new ExternalRedirectSelector(urlExpr);
        }
        if (encodedView.startsWith(FLOW_REDIRECT_PREFIX)) {
            String flowRedirect = encodedView.substring(FLOW_REDIRECT_PREFIX.length());
            Expression redirectExpr = (Expression)this.fromStringTo(class$org$springframework$binding$expression$Expression == null ? (class$org$springframework$binding$expression$Expression = TextToViewSelector.class$("org.springframework.binding.expression.Expression")) : class$org$springframework$binding$expression$Expression).execute((Object)flowRedirect);
            return new FlowRedirectSelector(redirectExpr);
        }
        if (encodedView.startsWith(BEAN_PREFIX)) {
            String id = encodedView.substring(BEAN_PREFIX.length());
            return this.flowServiceLocator.getViewSelector(id);
        }
        Expression viewNameExpr = (Expression)this.fromStringTo(class$org$springframework$binding$expression$Expression == null ? (class$org$springframework$binding$expression$Expression = TextToViewSelector.class$("org.springframework.binding.expression.Expression")) : class$org$springframework$binding$expression$Expression).execute((Object)encodedView);
        return new ApplicationViewSelector(viewNameExpr);
    }

    protected ViewSelector convertEncodedEndStateSelector(String encodedView) {
        if (encodedView.startsWith(REDIRECT_PREFIX)) {
            String externalUrl = encodedView.substring(REDIRECT_PREFIX.length());
            Expression urlExpr = (Expression)this.fromStringTo(class$org$springframework$binding$expression$Expression == null ? (class$org$springframework$binding$expression$Expression = TextToViewSelector.class$("org.springframework.binding.expression.Expression")) : class$org$springframework$binding$expression$Expression).execute((Object)externalUrl);
            return new ExternalRedirectSelector(urlExpr);
        }
        if (encodedView.startsWith(EXTERNAL_REDIRECT_PREFIX)) {
            String externalUrl = encodedView.substring(EXTERNAL_REDIRECT_PREFIX.length());
            Expression urlExpr = (Expression)this.fromStringTo(class$org$springframework$binding$expression$Expression == null ? (class$org$springframework$binding$expression$Expression = TextToViewSelector.class$("org.springframework.binding.expression.Expression")) : class$org$springframework$binding$expression$Expression).execute((Object)externalUrl);
            return new ExternalRedirectSelector(urlExpr);
        }
        if (encodedView.startsWith(FLOW_REDIRECT_PREFIX)) {
            String flowRedirect = encodedView.substring(FLOW_REDIRECT_PREFIX.length());
            Expression redirectExpr = (Expression)this.fromStringTo(class$org$springframework$binding$expression$Expression == null ? (class$org$springframework$binding$expression$Expression = TextToViewSelector.class$("org.springframework.binding.expression.Expression")) : class$org$springframework$binding$expression$Expression).execute((Object)flowRedirect);
            return new FlowRedirectSelector(redirectExpr);
        }
        if (encodedView.startsWith(BEAN_PREFIX)) {
            String id = encodedView.substring(BEAN_PREFIX.length());
            return this.flowServiceLocator.getViewSelector(id);
        }
        Expression viewNameExpr = (Expression)this.fromStringTo(class$org$springframework$binding$expression$Expression == null ? (class$org$springframework$binding$expression$Expression = TextToViewSelector.class$("org.springframework.binding.expression.Expression")) : class$org$springframework$binding$expression$Expression).execute((Object)encodedView);
        return new ApplicationViewSelector(viewNameExpr);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

