/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.builder;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.binding.convert.ConversionExecutor;
import org.springframework.binding.convert.ConversionService;
import org.springframework.binding.expression.Expression;
import org.springframework.binding.expression.ExpressionParser;
import org.springframework.binding.expression.PropertyExpression;
import org.springframework.binding.mapping.AttributeMapper;
import org.springframework.binding.mapping.DefaultAttributeMapper;
import org.springframework.binding.mapping.Mapping;
import org.springframework.binding.method.MethodSignature;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.springframework.util.xml.SimpleSaxErrorHandler;
import org.springframework.webflow.Action;
import org.springframework.webflow.AnnotatedAction;
import org.springframework.webflow.AttributeCollection;
import org.springframework.webflow.AttributeMap;
import org.springframework.webflow.Flow;
import org.springframework.webflow.FlowAttributeMapper;
import org.springframework.webflow.FlowExecutionExceptionHandler;
import org.springframework.webflow.FlowVariable;
import org.springframework.webflow.ScopeType;
import org.springframework.webflow.TargetStateResolver;
import org.springframework.webflow.Transition;
import org.springframework.webflow.TransitionCriteria;
import org.springframework.webflow.UnmodifiableAttributeMap;
import org.springframework.webflow.ViewSelector;
import org.springframework.webflow.action.MethodResultSpecification;
import org.springframework.webflow.builder.BaseFlowBuilder;
import org.springframework.webflow.builder.BeanInvokingActionFactory;
import org.springframework.webflow.builder.FlowArtifactFactory;
import org.springframework.webflow.builder.FlowBuilderException;
import org.springframework.webflow.builder.FlowServiceLocator;
import org.springframework.webflow.builder.LocalFlowServiceLocator;
import org.springframework.webflow.builder.LocalFlowServiceRegistry;
import org.springframework.webflow.builder.ResourceHolder;
import org.springframework.webflow.builder.WebFlowDtdResolver;
import org.springframework.webflow.support.BeanFactoryFlowVariable;
import org.springframework.webflow.support.CollectionAddingPropertyExpression;
import org.springframework.webflow.support.ImmutableFlowAttributeMapper;
import org.springframework.webflow.support.SimpleFlowVariable;
import org.springframework.webflow.support.TransitionCriteriaChain;
import org.springframework.webflow.support.TransitionExecutingStateExceptionHandler;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

public class XmlFlowBuilder
extends BaseFlowBuilder
implements ResourceHolder {
    private static final Log logger = LogFactory.getLog((Class)(class$org$springframework$webflow$builder$XmlFlowBuilder == null ? (class$org$springframework$webflow$builder$XmlFlowBuilder = XmlFlowBuilder.class$("org.springframework.webflow.builder.XmlFlowBuilder")) : class$org$springframework$webflow$builder$XmlFlowBuilder));
    private static final String ID_ATTRIBUTE = "id";
    private static final String BEAN_ATTRIBUTE = "bean";
    private static final String FLOW_ELEMENT = "flow";
    private static final String START_STATE_ATTRIBUTE = "start-state";
    private static final String ACTION_STATE_ELEMENT = "action-state";
    private static final String ACTION_ELEMENT = "action";
    private static final String NAME_ATTRIBUTE = "name";
    private static final String METHOD_ATTRIBUTE = "method";
    private static final String RESULT_NAME_ATTRIBUTE = "result-name";
    private static final String RESULT_SCOPE_ATTRIBUTE = "result-scope";
    private static final String DEFAULT_VALUE = "default";
    private static final String VIEW_STATE_ELEMENT = "view-state";
    private static final String VIEW_ATTRIBUTE = "view";
    private static final String DECISION_STATE_ELEMENT = "decision-state";
    private static final String IF_ELEMENT = "if";
    private static final String TEST_ATTRIBUTE = "test";
    private static final String THEN_ATTRIBUTE = "then";
    private static final String ELSE_ATTRIBUTE = "else";
    private static final String SUBFLOW_STATE_ELEMENT = "subflow-state";
    private static final String FLOW_ATTRIBUTE = "flow";
    private static final String ATTRIBUTE_MAPPER_ELEMENT = "attribute-mapper";
    private static final String OUTPUT_MAPPER_ELEMENT = "output-mapper";
    private static final String INPUT_MAPPER_ELEMENT = "input-mapper";
    private static final String MAPPING_ELEMENT = "mapping";
    private static final String SOURCE_ATTRIBUTE = "source";
    private static final String TARGET_ATTRIBUTE = "target";
    private static final String FROM_ATTRIBUTE = "from";
    private static final String TO_ATTRIBUTE = "to";
    private static final String TARGET_COLLECTION_ATTRIBUTE = "target-collection";
    private static final String END_STATE_ELEMENT = "end-state";
    private static final String TRANSITION_ELEMENT = "transition";
    private static final String GLOBAL_TRANSITIONS_ELEMENT = "global-transitions";
    private static final String ON_ATTRIBUTE = "on";
    private static final String ON_EXCEPTION_ATTRIBUTE = "on-exception";
    private static final String ATTRIBUTE_ELEMENT = "attribute";
    private static final String TYPE_ATTRIBUTE = "type";
    private static final String VALUE_ELEMENT = "value";
    private static final String VALUE_ATTRIBUTE = "value";
    private static final String VAR_ELEMENT = "var";
    private static final String SCOPE_ATTRIBUTE = "scope";
    private static final String CLASS_ATTRIBUTE = "class";
    private static final String START_ACTIONS_ELEMENT = "start-actions";
    private static final String END_ACTIONS_ELEMENT = "end-actions";
    private static final String ENTRY_ACTIONS_ELEMENT = "entry-actions";
    private static final String EXIT_ACTIONS_ELEMENT = "exit-actions";
    private static final String EXCEPTION_HANDLER_ELEMENT = "exception-handler";
    private static final String INLINE_FLOW_ELEMENT = "inline-flow";
    private static final String IMPORT_ELEMENT = "import";
    private static final String RESOURCE_ATTRIBUTE = "resource";
    protected Resource location;
    private LocalFlowServiceLocator localFlowServiceLocator;
    private boolean validating = true;
    private EntityResolver entityResolver = new WebFlowDtdResolver();
    private Document document;
    static /* synthetic */ Class class$org$springframework$webflow$builder$XmlFlowBuilder;
    static /* synthetic */ Class class$org$springframework$webflow$ScopeType;
    static /* synthetic */ Class class$java$lang$Class;
    static /* synthetic */ Class class$org$springframework$webflow$TransitionCriteria;
    static /* synthetic */ Class class$org$springframework$webflow$TargetStateResolver;
    static /* synthetic */ Class class$org$springframework$webflow$ViewSelector;
    static /* synthetic */ Class class$org$springframework$binding$method$MethodSignature;

    public XmlFlowBuilder(Resource location) {
        this.setLocation(location);
    }

    public XmlFlowBuilder(Resource location, FlowServiceLocator flowServiceLocator) {
        super(flowServiceLocator);
        this.setLocation(location);
    }

    public Resource getLocation() {
        return this.location;
    }

    public void setLocation(Resource location) {
        Assert.notNull((Object)location, (String)"The location property specifying the XML flow definition resource location is required");
        this.location = location;
    }

    public Resource getResource() {
        return this.location;
    }

    public boolean isValidating() {
        return this.validating;
    }

    public void setValidating(boolean validating) {
        this.validating = validating;
    }

    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    public void init(String id, AttributeCollection attributes) throws FlowBuilderException {
        this.localFlowServiceLocator = new LocalFlowServiceLocator(this.getFlowServiceLocator());
        try {
            this.document = this.loadDocument();
            Assert.notNull((Object)this.document, (String)"Document should never be null");
        }
        catch (IOException e) {
            throw new FlowBuilderException("Could not load the XML flow definition resource at " + this.getLocation(), e);
        }
        catch (ParserConfigurationException e) {
            throw new FlowBuilderException("Could not configure the parser to parse the XML flow definition at " + this.getLocation(), e);
        }
        catch (SAXException e) {
            throw new FlowBuilderException("Could not parse the flow definition XML document at " + this.getLocation(), e);
        }
        this.setFlow(this.parseFlow(id, attributes, this.getDocumentElement()));
    }

    public void buildVariables() throws FlowBuilderException {
        this.parseAndAddFlowVariables(this.getDocumentElement(), this.getFlow());
    }

    public void buildInputMapper() throws FlowBuilderException {
        this.getFlow().setInputMapper(this.parseInputMapper(this.getDocumentElement()));
    }

    public void buildStartActions() throws FlowBuilderException {
        this.parseAndAddStartActions(this.getDocumentElement(), this.getFlow());
    }

    public void buildInlineFlows() throws FlowBuilderException {
        this.parseAndAddInlineFlowDefinitions(this.getDocumentElement(), this.getFlow());
    }

    public void buildStates() throws FlowBuilderException {
        this.parseAndAddStateDefinitions(this.getDocumentElement(), this.getFlow());
    }

    public void buildGlobalTransitions() throws FlowBuilderException {
        this.parseAndAddGlobalTransitions(this.getDocumentElement(), this.getFlow());
    }

    public void buildEndActions() throws FlowBuilderException {
        this.parseAndAddEndActions(this.getDocumentElement(), this.getFlow());
    }

    public void buildOutputMapper() throws FlowBuilderException {
        this.getFlow().setOutputMapper(this.parseOutputMapper(this.getDocumentElement()));
    }

    public void buildExceptionHandlers() throws FlowBuilderException {
        this.getFlow().getExceptionHandlerSet().addAll(this.parseExceptionHandlers(this.getDocumentElement()));
    }

    public void dispose() {
        this.destroyLocalServiceRegistry(this.getFlow());
        this.document = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Document loadDocument() throws IOException, ParserConfigurationException, SAXException {
        InputStream is = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(this.isValidating());
            DocumentBuilder docBuilder = factory.newDocumentBuilder();
            docBuilder.setErrorHandler((ErrorHandler)new SimpleSaxErrorHandler(logger));
            docBuilder.setEntityResolver(this.getEntityResolver());
            is = this.getLocation().getInputStream();
            Document document = docBuilder.parse(is);
            return document;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ex) {
                    logger.warn((Object)"Could not close InputStream", (Throwable)ex);
                }
            }
        }
    }

    private Flow parseFlow(String id, AttributeCollection attributes, Element flowElement) {
        if (!this.isFlowElement(flowElement)) {
            throw new IllegalStateException("This is not the 'flow' element");
        }
        Flow flow = this.getFlowArtifactFactory().createFlow(id, this.parseAttributes(flowElement).union(attributes));
        this.initLocalServiceRegistry(flowElement, flow);
        return flow;
    }

    private FlowArtifactFactory getFlowArtifactFactory() {
        return this.getLocalFlowServiceLocator().getFlowArtifactFactory();
    }

    private boolean isFlowElement(Element flowElement) {
        return "flow".equals(flowElement.getTagName());
    }

    protected Document getDocument() {
        return this.document;
    }

    protected Element getDocumentElement() {
        return this.document.getDocumentElement();
    }

    protected FlowServiceLocator getLocalFlowServiceLocator() {
        return this.localFlowServiceLocator;
    }

    private void initLocalServiceRegistry(Element flowElement, Flow flow) {
        List importElements = DomUtils.getChildElementsByTagName((Element)flowElement, (String)IMPORT_ELEMENT);
        Resource[] resources = new Resource[importElements.size()];
        for (int i = 0; i < importElements.size(); ++i) {
            Element importElement = (Element)importElements.get(i);
            try {
                resources[i] = this.getLocation().createRelative(importElement.getAttribute(RESOURCE_ATTRIBUTE));
                continue;
            }
            catch (IOException e) {
                throw new FlowBuilderException("Could not access flow-relative artifact resource '" + importElement.getAttribute(RESOURCE_ATTRIBUTE) + "'", e);
            }
        }
        this.localFlowServiceLocator.push(new LocalFlowServiceRegistry(flow, resources));
    }

    private void parseAndAddFlowVariables(Element flowElement, Flow flow) {
        List varElements = DomUtils.getChildElementsByTagName((Element)flowElement, (String)VAR_ELEMENT);
        if (varElements.isEmpty()) {
            return;
        }
        for (int i = 0; i < varElements.size(); ++i) {
            flow.addVariable(this.parseVariable((Element)varElements.get(i)));
        }
    }

    private FlowVariable parseVariable(Element element) {
        ScopeType scope = null;
        if (element.hasAttribute(SCOPE_ATTRIBUTE) && !element.getAttribute(SCOPE_ATTRIBUTE).equals(DEFAULT_VALUE)) {
            scope = (ScopeType)((Object)this.fromStringTo(class$org$springframework$webflow$ScopeType == null ? (class$org$springframework$webflow$ScopeType = XmlFlowBuilder.class$("org.springframework.webflow.ScopeType")) : class$org$springframework$webflow$ScopeType).execute((Object)element.getAttribute(SCOPE_ATTRIBUTE)));
        }
        if (StringUtils.hasText((String)element.getAttribute(BEAN_ATTRIBUTE))) {
            BeanFactory beanFactory = this.getLocalFlowServiceLocator().getBeanFactory();
            return new BeanFactoryFlowVariable(element.getAttribute(NAME_ATTRIBUTE), element.getAttribute(BEAN_ATTRIBUTE), beanFactory, scope);
        }
        if (StringUtils.hasText((String)element.getAttribute(CLASS_ATTRIBUTE))) {
            Class variableClass = (Class)this.fromStringTo(class$java$lang$Class == null ? (class$java$lang$Class = XmlFlowBuilder.class$("java.lang.Class")) : class$java$lang$Class).execute((Object)element.getAttribute(CLASS_ATTRIBUTE));
            return new SimpleFlowVariable(element.getAttribute(NAME_ATTRIBUTE), variableClass, scope);
        }
        BeanFactory beanFactory = this.getLocalFlowServiceLocator().getBeanFactory();
        return new BeanFactoryFlowVariable(element.getAttribute(NAME_ATTRIBUTE), null, beanFactory, scope);
    }

    private void parseAndAddStartActions(Element element, Flow flow) {
        List startElements = DomUtils.getChildElementsByTagName((Element)element, (String)START_ACTIONS_ELEMENT);
        if (!startElements.isEmpty()) {
            Element startElement = (Element)startElements.get(0);
            flow.getStartActionList().addAll(this.parseAnnotatedActions(startElement));
        }
    }

    private void parseAndAddEndActions(Element element, Flow flow) {
        List endElements = DomUtils.getChildElementsByTagName((Element)element, (String)END_ACTIONS_ELEMENT);
        if (!endElements.isEmpty()) {
            Element endElement = (Element)endElements.get(0);
            flow.getEndActionList().addAll(this.parseAnnotatedActions(endElement));
        }
    }

    private void parseAndAddGlobalTransitions(Element element, Flow flow) {
        List globalTransitionElements = DomUtils.getChildElementsByTagName((Element)element, (String)GLOBAL_TRANSITIONS_ELEMENT);
        if (!globalTransitionElements.isEmpty()) {
            Element globalTransitionsElement = (Element)globalTransitionElements.get(0);
            flow.getGlobalTransitionSet().addAll(this.parseTransitions(globalTransitionsElement));
        }
    }

    private void parseAndAddInlineFlowDefinitions(Element parentFlowElement, Flow flow) {
        List inlineFlowElements = DomUtils.getChildElementsByTagName((Element)parentFlowElement, (String)INLINE_FLOW_ELEMENT);
        if (inlineFlowElements.isEmpty()) {
            return;
        }
        for (int i = 0; i < inlineFlowElements.size(); ++i) {
            Element inlineFlowElement = (Element)inlineFlowElements.get(i);
            String inlineFlowId = inlineFlowElement.getAttribute(ID_ATTRIBUTE);
            Element flowElement = (Element)inlineFlowElement.getElementsByTagName("flow").item(0);
            Flow inlineFlow = this.parseFlow(inlineFlowId, null, flowElement);
            this.buildInlineFlow(flowElement, inlineFlow);
            flow.addInlineFlow(inlineFlow);
        }
    }

    private void buildInlineFlow(Element flowElement, Flow inlineFlow) {
        this.parseAndAddFlowVariables(flowElement, inlineFlow);
        inlineFlow.setInputMapper(this.parseInputMapper(flowElement));
        this.parseAndAddStartActions(flowElement, inlineFlow);
        this.parseAndAddInlineFlowDefinitions(flowElement, inlineFlow);
        this.parseAndAddStateDefinitions(flowElement, inlineFlow);
        this.parseAndAddGlobalTransitions(flowElement, inlineFlow);
        inlineFlow.setOutputMapper(this.parseOutputMapper(flowElement));
        this.parseAndAddEndActions(flowElement, inlineFlow);
        inlineFlow.getExceptionHandlerSet().addAll(this.parseExceptionHandlers(flowElement));
        this.destroyLocalServiceRegistry(inlineFlow);
    }

    private void parseAndAddStateDefinitions(Element flowElement, Flow flow) {
        NodeList nodeList = flowElement.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            Element stateElement = (Element)node;
            if (ACTION_STATE_ELEMENT.equals(stateElement.getNodeName())) {
                this.parseAndAddActionState(stateElement, flow);
                continue;
            }
            if (VIEW_STATE_ELEMENT.equals(stateElement.getNodeName())) {
                this.parseAndAddViewState(stateElement, flow);
                continue;
            }
            if (DECISION_STATE_ELEMENT.equals(stateElement.getNodeName())) {
                this.parseAndAddDecisionState(stateElement, flow);
                continue;
            }
            if (SUBFLOW_STATE_ELEMENT.equals(stateElement.getNodeName())) {
                this.parseAndAddSubflowState(stateElement, flow);
                continue;
            }
            if (!END_STATE_ELEMENT.equals(stateElement.getNodeName())) continue;
            this.parseAndAddEndState(stateElement, flow);
        }
        this.parseAndSetStartState(flowElement, flow);
    }

    private void parseAndSetStartState(Element element, Flow flow) {
        String startStateId = element.getAttribute(START_STATE_ATTRIBUTE);
        flow.setStartState(startStateId);
    }

    private void parseAndAddActionState(Element element, Flow flow) {
        this.getFlowArtifactFactory().createActionState(this.parseId(element), flow, this.parseEntryActions(element), this.parseAnnotatedActions(element), this.parseTransitions(element), this.parseExceptionHandlers(element), this.parseExitActions(element), this.parseAttributes(element));
    }

    private void parseAndAddViewState(Element element, Flow flow) {
        this.getFlowArtifactFactory().createViewState(this.parseId(element), flow, this.parseEntryActions(element), this.parseViewSelector(VIEW_ATTRIBUTE, element), this.parseTransitions(element), this.parseExceptionHandlers(element), this.parseExitActions(element), this.parseAttributes(element));
    }

    private void parseAndAddDecisionState(Element element, Flow flow) {
        this.getFlowArtifactFactory().createDecisionState(this.parseId(element), flow, this.parseEntryActions(element), this.parseIfs(element), this.parseExceptionHandlers(element), this.parseExitActions(element), this.parseAttributes(element));
    }

    private void parseAndAddSubflowState(Element element, Flow flow) {
        this.getFlowArtifactFactory().createSubflowState(this.parseId(element), flow, this.parseEntryActions(element), this.parseSubflow(element), this.parseFlowAttributeMapper(element), this.parseTransitions(element), this.parseExceptionHandlers(element), this.parseExitActions(element), this.parseAttributes(element));
    }

    private void parseAndAddEndState(Element element, Flow flow) {
        this.getFlowArtifactFactory().createEndState(this.parseId(element), flow, this.parseEntryActions(element), this.parseViewSelector("end", element), this.parseOutputMapper(element), this.parseExceptionHandlers(element), this.parseAttributes(element));
    }

    private String parseId(Element element) {
        return element.getAttribute(ID_ATTRIBUTE);
    }

    private Action[] parseEntryActions(Element element) {
        List entryElements = DomUtils.getChildElementsByTagName((Element)element, (String)ENTRY_ACTIONS_ELEMENT);
        if (!entryElements.isEmpty()) {
            Element entryElement = (Element)entryElements.get(0);
            return this.parseAnnotatedActions(entryElement);
        }
        return null;
    }

    private Action[] parseExitActions(Element element) {
        List exitElements = DomUtils.getChildElementsByTagName((Element)element, (String)EXIT_ACTIONS_ELEMENT);
        if (!exitElements.isEmpty()) {
            Element exitElement = (Element)exitElements.get(0);
            return this.parseAnnotatedActions(exitElement);
        }
        return null;
    }

    private Transition[] parseTransitions(Element element) {
        LinkedList<Transition> transitions = new LinkedList<Transition>();
        List transitionElements = DomUtils.getChildElementsByTagName((Element)element, (String)TRANSITION_ELEMENT);
        for (int i = 0; i < transitionElements.size(); ++i) {
            Element transitionElement = (Element)transitionElements.get(i);
            if (StringUtils.hasText((String)transitionElement.getAttribute(ON_EXCEPTION_ATTRIBUTE))) continue;
            transitions.add(this.parseTransition(transitionElement));
        }
        return transitions.toArray(new Transition[transitions.size()]);
    }

    private Transition parseTransition(Element element) {
        TransitionCriteria matchingCriteria = (TransitionCriteria)this.fromStringTo(class$org$springframework$webflow$TransitionCriteria == null ? (class$org$springframework$webflow$TransitionCriteria = XmlFlowBuilder.class$("org.springframework.webflow.TransitionCriteria")) : class$org$springframework$webflow$TransitionCriteria).execute((Object)element.getAttribute(ON_ATTRIBUTE));
        TransitionCriteria executionCriteria = TransitionCriteriaChain.criteriaChainFor(this.parseAnnotatedActions(element));
        TargetStateResolver targetStateResolver = (TargetStateResolver)this.fromStringTo(class$org$springframework$webflow$TargetStateResolver == null ? (class$org$springframework$webflow$TargetStateResolver = XmlFlowBuilder.class$("org.springframework.webflow.TargetStateResolver")) : class$org$springframework$webflow$TargetStateResolver).execute((Object)element.getAttribute(TO_ATTRIBUTE));
        return this.getFlowArtifactFactory().createTransition(matchingCriteria, executionCriteria, targetStateResolver, this.parseAttributes(element));
    }

    private ViewSelector parseViewSelector(String stateType, Element element) {
        String viewName = element.getAttribute(VIEW_ATTRIBUTE);
        HashMap<String, String> context = new HashMap<String, String>(1, 1.0f);
        context.put("stateType", stateType);
        return (ViewSelector)this.fromStringTo(class$org$springframework$webflow$ViewSelector == null ? (class$org$springframework$webflow$ViewSelector = XmlFlowBuilder.class$("org.springframework.webflow.ViewSelector")) : class$org$springframework$webflow$ViewSelector).execute((Object)viewName, context);
    }

    private Flow parseSubflow(Element element) {
        return this.getLocalFlowServiceLocator().getSubflow(element.getAttribute("flow"));
    }

    private AnnotatedAction[] parseAnnotatedActions(Element element) {
        LinkedList<AnnotatedAction> actions = new LinkedList<AnnotatedAction>();
        List actionElements = DomUtils.getChildElementsByTagName((Element)element, (String)ACTION_ELEMENT);
        Iterator it = actionElements.iterator();
        while (it.hasNext()) {
            actions.add(this.parseAnnotatedAction((Element)it.next()));
        }
        return actions.toArray(new AnnotatedAction[actions.size()]);
    }

    private AnnotatedAction parseAnnotatedAction(Element element) {
        AnnotatedAction annotated = new AnnotatedAction(this.parseAction(element));
        if (element.hasAttribute(NAME_ATTRIBUTE)) {
            annotated.setName(element.getAttribute(NAME_ATTRIBUTE));
        }
        if (element.hasAttribute(METHOD_ATTRIBUTE) && this.getLocalFlowServiceLocator().isAction(element.getAttribute(BEAN_ATTRIBUTE))) {
            annotated.setMethod(element.getAttribute(METHOD_ATTRIBUTE));
        }
        annotated.getAttributeMap().putAll(this.parseAttributes(element));
        return annotated;
    }

    private Action parseAction(Element element) {
        String actionId = element.getAttribute(BEAN_ATTRIBUTE);
        if (this.getLocalFlowServiceLocator().isAction(actionId)) {
            return this.getLocalFlowServiceLocator().getAction(actionId);
        }
        return this.parseBeanInvokingAction(actionId, element);
    }

    private Action parseBeanInvokingAction(String beanId, Element element) {
        Assert.isTrue((boolean)element.hasAttribute(METHOD_ATTRIBUTE), (String)"The method attribute is required for bean invoking actions");
        MethodSignature methodSignature = (MethodSignature)this.fromStringTo(class$org$springframework$binding$method$MethodSignature == null ? (class$org$springframework$binding$method$MethodSignature = XmlFlowBuilder.class$("org.springframework.binding.method.MethodSignature")) : class$org$springframework$binding$method$MethodSignature).execute((Object)element.getAttribute(METHOD_ATTRIBUTE));
        String resultName = null;
        if (element.hasAttribute(RESULT_NAME_ATTRIBUTE)) {
            resultName = element.getAttribute(RESULT_NAME_ATTRIBUTE);
        }
        ScopeType resultScope = null;
        if (element.hasAttribute(RESULT_SCOPE_ATTRIBUTE) && !element.getAttribute(RESULT_SCOPE_ATTRIBUTE).equals(DEFAULT_VALUE)) {
            resultScope = (ScopeType)((Object)this.fromStringTo(class$org$springframework$webflow$ScopeType == null ? (class$org$springframework$webflow$ScopeType = XmlFlowBuilder.class$("org.springframework.webflow.ScopeType")) : class$org$springframework$webflow$ScopeType).execute((Object)element.getAttribute(RESULT_SCOPE_ATTRIBUTE)));
        }
        MethodResultSpecification resultSpecification = null;
        if (resultName != null) {
            resultSpecification = new MethodResultSpecification(resultName, resultScope != null ? resultScope : ScopeType.REQUEST);
        }
        return this.getBeanInvokingActionFactory().createBeanInvokingAction(beanId, this.getLocalFlowServiceLocator().getBeanFactory(), methodSignature, resultSpecification, this.getLocalFlowServiceLocator().getConversionService(), null);
    }

    private BeanInvokingActionFactory getBeanInvokingActionFactory() {
        return this.getFlowServiceLocator().getBeanInvokingActionFactory();
    }

    private UnmodifiableAttributeMap parseAttributes(Element element) {
        AttributeMap attributes = new AttributeMap();
        List propertyElements = DomUtils.getChildElementsByTagName((Element)element, (String)ATTRIBUTE_ELEMENT);
        for (int i = 0; i < propertyElements.size(); ++i) {
            this.parseAndSetAttribute((Element)propertyElements.get(i), attributes);
        }
        return attributes.unmodifiable();
    }

    private void parseAndSetAttribute(Element element, AttributeMap attributes) {
        String name = element.getAttribute(NAME_ATTRIBUTE);
        String value = null;
        if (element.hasAttribute("value")) {
            value = element.getAttribute("value");
        } else {
            List valueElements = DomUtils.getChildElementsByTagName((Element)element, (String)"value");
            Assert.state((valueElements.size() == 1 ? 1 : 0) != 0, (String)("A property value should be specified for property '" + name + "'"));
            value = DomUtils.getTextValue((Element)((Element)valueElements.get(0)));
        }
        attributes.put(name, this.convertPropertyValue(element, value));
    }

    private Object convertPropertyValue(Element element, String stringValue) {
        if (element.hasAttribute(TYPE_ATTRIBUTE)) {
            ConversionExecutor executor = this.fromStringTo(element.getAttribute(TYPE_ATTRIBUTE));
            if (executor != null) {
                return executor.execute((Object)stringValue);
            }
            Class targetClass = (Class)this.fromStringTo(class$java$lang$Class == null ? (class$java$lang$Class = XmlFlowBuilder.class$("java.lang.Class")) : class$java$lang$Class).execute((Object)element.getAttribute(TYPE_ATTRIBUTE));
            return this.fromStringTo(targetClass).execute((Object)stringValue);
        }
        return stringValue;
    }

    private Transition[] parseIfs(Element element) {
        LinkedList<Transition> transitions = new LinkedList<Transition>();
        List transitionElements = DomUtils.getChildElementsByTagName((Element)element, (String)IF_ELEMENT);
        Iterator it = transitionElements.iterator();
        while (it.hasNext()) {
            transitions.addAll(Arrays.asList(this.parseIf((Element)it.next())));
        }
        return transitions.toArray(new Transition[transitions.size()]);
    }

    private Transition[] parseIf(Element element) {
        Transition thenTransition = this.parseThen(element);
        if (StringUtils.hasText((String)element.getAttribute(ELSE_ATTRIBUTE))) {
            Transition elseTransition = this.parseElse(element);
            return new Transition[]{thenTransition, elseTransition};
        }
        return new Transition[]{thenTransition};
    }

    private Transition parseThen(Element element) {
        TransitionCriteria matchingCriteria = (TransitionCriteria)this.fromStringTo(class$org$springframework$webflow$TransitionCriteria == null ? (class$org$springframework$webflow$TransitionCriteria = XmlFlowBuilder.class$("org.springframework.webflow.TransitionCriteria")) : class$org$springframework$webflow$TransitionCriteria).execute((Object)element.getAttribute(TEST_ATTRIBUTE));
        TargetStateResolver targetStateResolver = (TargetStateResolver)this.fromStringTo(class$org$springframework$webflow$TargetStateResolver == null ? (class$org$springframework$webflow$TargetStateResolver = XmlFlowBuilder.class$("org.springframework.webflow.TargetStateResolver")) : class$org$springframework$webflow$TargetStateResolver).execute((Object)element.getAttribute(THEN_ATTRIBUTE));
        return this.getFlowArtifactFactory().createTransition(matchingCriteria, null, targetStateResolver, null);
    }

    private Transition parseElse(Element element) {
        TargetStateResolver targetStateResolver = (TargetStateResolver)this.fromStringTo(class$org$springframework$webflow$TargetStateResolver == null ? (class$org$springframework$webflow$TargetStateResolver = XmlFlowBuilder.class$("org.springframework.webflow.TargetStateResolver")) : class$org$springframework$webflow$TargetStateResolver).execute((Object)element.getAttribute(ELSE_ATTRIBUTE));
        return this.getFlowArtifactFactory().createTransition(null, null, targetStateResolver, null);
    }

    private FlowAttributeMapper parseFlowAttributeMapper(Element element) {
        List mapperElements = DomUtils.getChildElementsByTagName((Element)element, (String)ATTRIBUTE_MAPPER_ELEMENT);
        if (mapperElements.isEmpty()) {
            return null;
        }
        Element mapperElement = (Element)mapperElements.get(0);
        if (StringUtils.hasText((String)mapperElement.getAttribute(BEAN_ATTRIBUTE))) {
            return this.getLocalFlowServiceLocator().getAttributeMapper(mapperElement.getAttribute(BEAN_ATTRIBUTE));
        }
        return new ImmutableFlowAttributeMapper(this.parseInputMapper(mapperElement), this.parseOutputMapper(mapperElement));
    }

    private AttributeMapper parseInputMapper(Element element) {
        List mapperElements = DomUtils.getChildElementsByTagName((Element)element, (String)INPUT_MAPPER_ELEMENT);
        return mapperElements.isEmpty() ? null : this.parseAttributeMapper((Element)mapperElements.get(0));
    }

    private AttributeMapper parseOutputMapper(Element element) {
        List mapperElements = DomUtils.getChildElementsByTagName((Element)element, (String)OUTPUT_MAPPER_ELEMENT);
        return mapperElements.isEmpty() ? null : this.parseAttributeMapper((Element)mapperElements.get(0));
    }

    private AttributeMapper parseAttributeMapper(Element element) {
        List mappingElements = DomUtils.getChildElementsByTagName((Element)element, (String)MAPPING_ELEMENT);
        DefaultAttributeMapper mapper = new DefaultAttributeMapper();
        Iterator it = mappingElements.iterator();
        ExpressionParser parser = this.getLocalFlowServiceLocator().getExpressionParser();
        while (it.hasNext()) {
            Element mappingElement = (Element)it.next();
            Expression source = parser.parseExpression(mappingElement.getAttribute(SOURCE_ATTRIBUTE));
            PropertyExpression target = null;
            if (StringUtils.hasText((String)mappingElement.getAttribute(TARGET_ATTRIBUTE))) {
                target = parser.parsePropertyExpression(mappingElement.getAttribute(TARGET_ATTRIBUTE));
            } else if (StringUtils.hasText((String)mappingElement.getAttribute(TARGET_COLLECTION_ATTRIBUTE))) {
                target = new CollectionAddingPropertyExpression((Expression)parser.parsePropertyExpression(mappingElement.getAttribute(TARGET_COLLECTION_ATTRIBUTE)));
            }
            mapper.addMapping(new Mapping(source, target, this.parseTypeConverter(mappingElement)));
        }
        return mapper;
    }

    private ConversionExecutor parseTypeConverter(Element element) {
        String from = element.getAttribute(FROM_ATTRIBUTE);
        String to = element.getAttribute(TO_ATTRIBUTE);
        if (StringUtils.hasText((String)from)) {
            if (StringUtils.hasText((String)to)) {
                ConversionService service = this.getLocalFlowServiceLocator().getConversionService();
                return service.getConversionExecutor(service.getClassByAlias(from), service.getClassByAlias(to));
            }
            throw new IllegalArgumentException("Use of the 'from' attribute requires use of the 'to' attribute");
        }
        Assert.isTrue((!StringUtils.hasText((String)to) ? 1 : 0) != 0, (String)"Use of the 'to' attribute requires use of the 'from' attribute");
        return null;
    }

    private FlowExecutionExceptionHandler[] parseExceptionHandlers(Element element) {
        FlowExecutionExceptionHandler[] transitionExecutingHandlers = this.parseTransitionExecutingExceptionHandlers(element);
        FlowExecutionExceptionHandler[] customHandlers = this.parseCustomExceptionHandlers(element);
        FlowExecutionExceptionHandler[] exceptionHandlers = new FlowExecutionExceptionHandler[transitionExecutingHandlers.length + customHandlers.length];
        System.arraycopy(transitionExecutingHandlers, 0, exceptionHandlers, 0, transitionExecutingHandlers.length);
        System.arraycopy(customHandlers, 0, exceptionHandlers, transitionExecutingHandlers.length, customHandlers.length);
        return exceptionHandlers;
    }

    private FlowExecutionExceptionHandler[] parseTransitionExecutingExceptionHandlers(Element element) {
        List transitionElements = Collections.EMPTY_LIST;
        if (this.isFlowElement(element)) {
            List globalTransitionElements = DomUtils.getChildElementsByTagName((Element)element, (String)GLOBAL_TRANSITIONS_ELEMENT);
            if (!globalTransitionElements.isEmpty()) {
                Element globalTransitionsElement = (Element)globalTransitionElements.get(0);
                transitionElements = DomUtils.getChildElementsByTagName((Element)globalTransitionsElement, (String)TRANSITION_ELEMENT);
            }
        } else {
            transitionElements = DomUtils.getChildElementsByTagName((Element)element, (String)TRANSITION_ELEMENT);
        }
        LinkedList<FlowExecutionExceptionHandler> exceptionHandlers = new LinkedList<FlowExecutionExceptionHandler>();
        for (int i = 0; i < transitionElements.size(); ++i) {
            Element transitionElement = (Element)transitionElements.get(i);
            if (!StringUtils.hasText((String)transitionElement.getAttribute(ON_EXCEPTION_ATTRIBUTE))) continue;
            exceptionHandlers.add(this.parseTransitionExecutingExceptionHandler(transitionElement));
        }
        return exceptionHandlers.toArray(new FlowExecutionExceptionHandler[exceptionHandlers.size()]);
    }

    private FlowExecutionExceptionHandler parseTransitionExecutingExceptionHandler(Element element) {
        TransitionExecutingStateExceptionHandler handler = new TransitionExecutingStateExceptionHandler();
        Class exceptionClass = (Class)this.fromStringTo(class$java$lang$Class == null ? (class$java$lang$Class = XmlFlowBuilder.class$("java.lang.Class")) : class$java$lang$Class).execute((Object)element.getAttribute(ON_EXCEPTION_ATTRIBUTE));
        handler.add(exceptionClass, (TargetStateResolver)this.fromStringTo(class$org$springframework$webflow$TargetStateResolver == null ? (class$org$springframework$webflow$TargetStateResolver = XmlFlowBuilder.class$("org.springframework.webflow.TargetStateResolver")) : class$org$springframework$webflow$TargetStateResolver).execute((Object)element.getAttribute(TO_ATTRIBUTE)));
        return handler;
    }

    private FlowExecutionExceptionHandler[] parseCustomExceptionHandlers(Element element) {
        LinkedList<FlowExecutionExceptionHandler> exceptionHandlers = new LinkedList<FlowExecutionExceptionHandler>();
        List handlerElements = DomUtils.getChildElementsByTagName((Element)element, (String)EXCEPTION_HANDLER_ELEMENT);
        for (int i = 0; i < handlerElements.size(); ++i) {
            Element handlerElement = (Element)handlerElements.get(i);
            exceptionHandlers.add(this.parseCustomExceptionHandler(handlerElement));
        }
        return exceptionHandlers.toArray(new FlowExecutionExceptionHandler[exceptionHandlers.size()]);
    }

    private FlowExecutionExceptionHandler parseCustomExceptionHandler(Element element) {
        return this.getLocalFlowServiceLocator().getExceptionHandler(element.getAttribute(BEAN_ATTRIBUTE));
    }

    private void destroyLocalServiceRegistry(Flow flow) {
        this.localFlowServiceLocator.pop();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

