/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.context;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public abstract class StringKeyedMapAdapter
implements Map {
    private Set keySet;
    private Collection values;
    private Set entrySet;

    public void clear() {
        Iterator it = this.getAttributeNames();
        while (it.hasNext()) {
            this.removeAttribute((String)it.next());
        }
    }

    public boolean containsKey(Object key) {
        return this.getAttribute(key.toString()) != null;
    }

    public boolean containsValue(Object value) {
        if (value == null) {
            return false;
        }
        Iterator it = this.getAttributeNames();
        while (it.hasNext()) {
            Object aValue = this.getAttribute((String)it.next());
            if (!value.equals(aValue)) continue;
            return true;
        }
        return false;
    }

    public Set entrySet() {
        return this.entrySet != null ? this.entrySet : (this.entrySet = new EntrySet());
    }

    public Object get(Object key) {
        return this.getAttribute(key.toString());
    }

    public boolean isEmpty() {
        return !this.getAttributeNames().hasNext();
    }

    public Set keySet() {
        return this.keySet != null ? this.keySet : (this.keySet = new KeySet());
    }

    public Object put(Object key, Object value) {
        String stringKey = String.valueOf(key);
        Object previousValue = this.getAttribute(stringKey);
        this.setAttribute(stringKey, value);
        return previousValue;
    }

    public void putAll(Map map) {
        Iterator it = map.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            this.setAttribute(entry.getKey().toString(), entry.getValue());
        }
    }

    public Object remove(Object key) {
        String stringKey = key.toString();
        Object retval = this.getAttribute(stringKey);
        this.removeAttribute(stringKey);
        return retval;
    }

    public int size() {
        int size = 0;
        Iterator it = this.getAttributeNames();
        while (it.hasNext()) {
            ++size;
            it.next();
        }
        return size;
    }

    public Collection values() {
        return this.values != null ? this.values : (this.values = new Values());
    }

    protected abstract Object getAttribute(String var1);

    protected abstract void setAttribute(String var1, Object var2);

    protected abstract void removeAttribute(String var1);

    protected abstract Iterator getAttributeNames();

    private class EntrySetEntry
    implements Map.Entry {
        private final Object currentKey;

        public EntrySetEntry(Object currentKey) {
            this.currentKey = currentKey;
        }

        public Object getKey() {
            return this.currentKey;
        }

        public Object getValue() {
            return StringKeyedMapAdapter.this.get(this.currentKey);
        }

        public Object setValue(Object value) {
            return StringKeyedMapAdapter.this.put(this.currentKey, value);
        }
    }

    private class EntryIterator
    extends KeyIterator {
        private EntryIterator() {
        }

        public Object next() {
            super.next();
            return new EntrySetEntry(this.currentKey);
        }
    }

    private class EntrySet
    extends AbstractSet {
        private EntrySet() {
        }

        public Iterator iterator() {
            return new EntryIterator();
        }

        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)o;
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (key == null || value == null) {
                return false;
            }
            return value.equals(StringKeyedMapAdapter.this.get(key));
        }

        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)o;
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (key == null || value == null || !value.equals(StringKeyedMapAdapter.this.get(key))) {
                return false;
            }
            return StringKeyedMapAdapter.this.remove(((Map.Entry)o).getKey()) != null;
        }
    }

    private class ValuesIterator
    extends KeyIterator {
        private ValuesIterator() {
        }

        public Object next() {
            super.next();
            return StringKeyedMapAdapter.this.get(this.currentKey);
        }
    }

    private class Values
    extends AbstractSet {
        private Values() {
        }

        public Iterator iterator() {
            return new ValuesIterator();
        }

        public boolean contains(Object o) {
            return StringKeyedMapAdapter.this.containsValue(o);
        }

        public boolean remove(Object o) {
            if (o == null) {
                return false;
            }
            Iterator it = this.iterator();
            while (it.hasNext()) {
                if (!o.equals(it.next())) continue;
                it.remove();
                return true;
            }
            return false;
        }
    }

    private class KeyIterator
    implements Iterator {
        protected final Iterator it;
        protected Object currentKey;

        private KeyIterator() {
            this.it = StringKeyedMapAdapter.this.getAttributeNames();
        }

        public void remove() {
            if (this.currentKey == null) {
                throw new NoSuchElementException("You must call next() at least once");
            }
            StringKeyedMapAdapter.this.remove(this.currentKey);
        }

        public boolean hasNext() {
            return this.it.hasNext();
        }

        public Object next() {
            this.currentKey = this.it.next();
            return this.currentKey;
        }
    }

    private class KeySet
    extends AbstractSet {
        private KeySet() {
        }

        public Iterator iterator() {
            return new KeyIterator();
        }

        public boolean contains(Object o) {
            return StringKeyedMapAdapter.this.containsKey(o);
        }

        public boolean remove(Object o) {
            return StringKeyedMapAdapter.this.remove(o) != null;
        }
    }

    private abstract class AbstractSet
    extends java.util.AbstractSet {
        private AbstractSet() {
        }

        public boolean isEmpty() {
            return StringKeyedMapAdapter.this.isEmpty();
        }

        public int size() {
            return StringKeyedMapAdapter.this.size();
        }

        public void clear() {
            StringKeyedMapAdapter.this.clear();
        }
    }
}

