/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.context.portlet;

import javax.portlet.PortletContext;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import org.springframework.core.style.ToStringCreator;
import org.springframework.webflow.AttributeMap;
import org.springframework.webflow.ExternalContext;
import org.springframework.webflow.ParameterMap;
import org.springframework.webflow.SharedAttributeMap;
import org.springframework.webflow.context.portlet.PortletContextMap;
import org.springframework.webflow.context.portlet.PortletRequestMap;
import org.springframework.webflow.context.portlet.PortletRequestParameterMap;
import org.springframework.webflow.context.portlet.PortletSessionMap;

public class PortletExternalContext
implements ExternalContext {
    private PortletContext context;
    private PortletRequest request;
    private PortletResponse response;

    public PortletExternalContext(PortletContext context, PortletRequest request, PortletResponse response) {
        this.context = context;
        this.request = request;
        this.response = response;
    }

    public String getContextPath() {
        return this.request.getContextPath();
    }

    public String getDispatcherPath() {
        return null;
    }

    public String getRequestPathInfo() {
        return null;
    }

    public ParameterMap getRequestParameterMap() {
        return new ParameterMap(new PortletRequestParameterMap(this.request));
    }

    public AttributeMap getRequestMap() {
        return new AttributeMap(new PortletRequestMap(this.request));
    }

    public SharedAttributeMap getSessionMap() {
        return new SharedAttributeMap(new PortletSessionMap(this.request, 2));
    }

    public SharedAttributeMap getGlobalSessionMap() {
        return new SharedAttributeMap(new PortletSessionMap(this.request, 1));
    }

    public SharedAttributeMap getApplicationMap() {
        return new SharedAttributeMap(new PortletContextMap(this.context));
    }

    public PortletContext getContext() {
        return this.context;
    }

    public PortletRequest getRequest() {
        return this.request;
    }

    public PortletResponse getResponse() {
        return this.response;
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("requestParameterMap", (Object)this.getRequestParameterMap()).toString();
    }
}

