/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.context.portlet;

import java.util.Iterator;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import org.springframework.web.util.WebUtils;
import org.springframework.webflow.CollectionUtils;
import org.springframework.webflow.SharedMap;
import org.springframework.webflow.context.StringKeyedMapAdapter;

public class PortletSessionMap
extends StringKeyedMapAdapter
implements SharedMap {
    private PortletRequest request;
    private int scope;

    public PortletSessionMap(PortletRequest request, int scope) {
        this.request = request;
        this.scope = scope;
    }

    private PortletSession getSession() {
        return this.request.getPortletSession(false);
    }

    protected Object getAttribute(String key) {
        PortletSession session = this.getSession();
        return session == null ? null : session.getAttribute(key, this.scope);
    }

    protected void setAttribute(String key, Object value) {
        this.request.getPortletSession(true).setAttribute(key, value, this.scope);
    }

    protected void removeAttribute(String key) {
        PortletSession session = this.getSession();
        if (session != null) {
            session.removeAttribute(key, this.scope);
        }
    }

    protected Iterator getAttributeNames() {
        PortletSession session = this.getSession();
        return session == null ? CollectionUtils.EMPTY_ITERATOR : CollectionUtils.iterator(session.getAttributeNames(this.scope));
    }

    public Object getMutex() {
        PortletSession session = this.request.getPortletSession(true);
        Object mutex = session.getAttribute(WebUtils.SESSION_MUTEX_ATTRIBUTE);
        return mutex != null ? mutex : session;
    }
}

