/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.context.servlet;

import java.util.Enumeration;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.webflow.CollectionUtils;
import org.springframework.webflow.context.StringKeyedMapAdapter;

public class HttpServletRequestParameterMap
extends StringKeyedMapAdapter {
    private HttpServletRequest request;

    public HttpServletRequestParameterMap(HttpServletRequest request) {
        this.request = request;
    }

    protected Object getAttribute(String key) {
        MultipartHttpServletRequest multipartRequest;
        Object data;
        if (this.request instanceof MultipartHttpServletRequest && (data = (multipartRequest = (MultipartHttpServletRequest)this.request).getFileMap().get(key)) != null) {
            return data;
        }
        String[] parameters = this.request.getParameterValues(key);
        if (parameters == null) {
            return null;
        }
        if (parameters.length == 1) {
            return parameters[0];
        }
        return parameters;
    }

    protected void setAttribute(String key, Object value) {
        throw new UnsupportedOperationException("HttpServletRequest parameter maps are immutable");
    }

    protected void removeAttribute(String key) {
        throw new UnsupportedOperationException("HttpServletRequest parameter maps are immutable");
    }

    protected Iterator getAttributeNames() {
        Enumeration parameterNames = this.request.getParameterNames();
        if (this.request instanceof MultipartHttpServletRequest) {
            MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)this.request;
            return new MultiPartIterator(multipartRequest.getFileMap().keySet().iterator(), parameterNames);
        }
        return CollectionUtils.iterator(parameterNames);
    }

    private static class MultiPartIterator
    implements Iterator {
        private Iterator fileMapNames;
        private Enumeration parameterNames;

        public MultiPartIterator(Iterator fileMapNames, Enumeration parameterNames) {
            this.fileMapNames = fileMapNames;
            this.parameterNames = parameterNames;
        }

        public boolean hasNext() {
            return this.fileMapNames.hasNext() || this.parameterNames.hasMoreElements();
        }

        public Object next() {
            if (this.fileMapNames.hasNext()) {
                return this.fileMapNames.next();
            }
            return this.parameterNames.nextElement();
        }

        public void remove() {
            throw new UnsupportedOperationException("Remove not supported");
        }
    }
}

