/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.execution;

import java.util.Iterator;
import java.util.Set;
import org.springframework.core.CollectionFactory;
import org.springframework.util.Assert;
import org.springframework.webflow.Flow;
import org.springframework.webflow.execution.FlowExecutionListener;
import org.springframework.webflow.execution.FlowExecutionListenerCriteria;

class ConditionalFlowExecutionListenerHolder {
    private FlowExecutionListener listener;
    private Set criteriaSet = CollectionFactory.createLinkedSetIfPossible((int)3);

    public ConditionalFlowExecutionListenerHolder(FlowExecutionListener listener) {
        Assert.notNull((Object)listener, (String)"The listener is required");
        this.listener = listener;
    }

    public FlowExecutionListener getListener() {
        return this.listener;
    }

    public void add(FlowExecutionListenerCriteria criteria) {
        this.criteriaSet.add(criteria);
    }

    public void remove(FlowExecutionListenerCriteria criteria) {
        this.criteriaSet.remove(criteria);
    }

    public boolean isCriteriaSetEmpty() {
        return this.criteriaSet.isEmpty();
    }

    public boolean equals(Object o) {
        if (!(o instanceof ConditionalFlowExecutionListenerHolder)) {
            return false;
        }
        return this.listener.equals(((ConditionalFlowExecutionListenerHolder)o).listener);
    }

    public int hashCode() {
        return this.listener.hashCode();
    }

    public boolean listenerAppliesTo(Flow flow) {
        Iterator it = this.criteriaSet.iterator();
        while (it.hasNext()) {
            FlowExecutionListenerCriteria criteria = (FlowExecutionListenerCriteria)it.next();
            if (!criteria.appliesTo(flow)) continue;
            return true;
        }
        return false;
    }
}

