/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.execution;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.style.StylerUtils;
import org.springframework.util.Assert;
import org.springframework.webflow.Flow;
import org.springframework.webflow.execution.ConditionalFlowExecutionListenerHolder;
import org.springframework.webflow.execution.FlowExecutionListener;
import org.springframework.webflow.execution.FlowExecutionListenerCriteria;
import org.springframework.webflow.execution.FlowExecutionListenerCriteriaFactory;
import org.springframework.webflow.execution.FlowExecutionListenerLoader;

public class ConditionalFlowExecutionListenerLoader
implements FlowExecutionListenerLoader {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private List listeners = new LinkedList();

    public void addListener(FlowExecutionListener listener) {
        this.addListener(listener, null);
    }

    public void addListeners(FlowExecutionListener[] listeners, FlowExecutionListenerCriteria criteria) {
        for (int i = 0; i < listeners.length; ++i) {
            this.addListener(listeners[i], criteria);
        }
    }

    public void addListener(FlowExecutionListener listener, FlowExecutionListenerCriteria criteria) {
        ConditionalFlowExecutionListenerHolder conditional;
        if (listener == null) {
            return;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Adding flow execution listener " + listener + " with criteria " + criteria));
        }
        if ((conditional = this.getHolder(listener)) == null) {
            conditional = new ConditionalFlowExecutionListenerHolder(listener);
            this.listeners.add(conditional);
        }
        if (criteria == null) {
            criteria = new FlowExecutionListenerCriteriaFactory().allFlows();
        }
        conditional.add(criteria);
    }

    public boolean containsListener(FlowExecutionListener listener) {
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            ConditionalFlowExecutionListenerHolder h = (ConditionalFlowExecutionListenerHolder)it.next();
            if (!h.getListener().equals(listener)) continue;
            return true;
        }
        return false;
    }

    public void removeListener(FlowExecutionListener listener) {
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            ConditionalFlowExecutionListenerHolder h = (ConditionalFlowExecutionListenerHolder)it.next();
            if (!h.getListener().equals(listener)) continue;
            it.remove();
        }
    }

    public void removeAllListeners() {
        this.listeners.clear();
    }

    public void removeListenerCriteria(FlowExecutionListener listener, FlowExecutionListenerCriteria criteria) {
        if (this.containsListener(listener)) {
            ConditionalFlowExecutionListenerHolder listenerHolder = this.getHolder(listener);
            listenerHolder.remove(criteria);
            if (listenerHolder.isCriteriaSetEmpty()) {
                this.removeListener(listener);
            }
        }
    }

    public FlowExecutionListener[] getListeners(Flow flow) {
        Assert.notNull((Object)flow, (String)"The Flow to load listeners for cannot be null");
        LinkedList<FlowExecutionListener> listenersToAttach = new LinkedList<FlowExecutionListener>();
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            ConditionalFlowExecutionListenerHolder listenerHolder = (ConditionalFlowExecutionListenerHolder)it.next();
            if (!listenerHolder.listenerAppliesTo(flow)) continue;
            listenersToAttach.add(listenerHolder.getListener());
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Loaded [" + listenersToAttach.size() + "] of possible " + this.listeners.size() + " listeners to this execution request for flow '" + flow.getId() + "', the listeners to attach are " + StylerUtils.style(listenersToAttach)));
        }
        return listenersToAttach.toArray(new FlowExecutionListener[listenersToAttach.size()]);
    }

    protected ConditionalFlowExecutionListenerHolder getHolder(FlowExecutionListener listener) {
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            ConditionalFlowExecutionListenerHolder next = (ConditionalFlowExecutionListenerHolder)it.next();
            if (!next.getListener().equals(listener)) continue;
            return next;
        }
        return null;
    }
}

