/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.execution.impl;

import org.springframework.webflow.AttributeMap;
import org.springframework.webflow.Event;
import org.springframework.webflow.Flow;
import org.springframework.webflow.FlowSession;
import org.springframework.webflow.RequestContext;
import org.springframework.webflow.State;
import org.springframework.webflow.UnmodifiableAttributeMap;
import org.springframework.webflow.ViewSelection;
import org.springframework.webflow.execution.FlowExecutionListener;

public class FlowExecutionListeners {
    private FlowExecutionListener[] listeners;

    public FlowExecutionListeners() {
        this(null);
    }

    public FlowExecutionListeners(FlowExecutionListener[] listeners) {
        this.listeners = listeners != null ? listeners : new FlowExecutionListener[0];
    }

    public FlowExecutionListener[] getArray() {
        return this.listeners;
    }

    public int size() {
        return this.listeners.length;
    }

    public void fireRequestSubmitted(RequestContext context) {
        for (int i = 0; i < this.listeners.length; ++i) {
            this.listeners[i].requestSubmitted(context);
        }
    }

    public void fireRequestProcessed(RequestContext context) {
        for (int i = 0; i < this.listeners.length; ++i) {
            this.listeners[i].requestProcessed(context);
        }
    }

    public void fireSessionStarting(RequestContext context, Flow flow, AttributeMap input) {
        for (int i = 0; i < this.listeners.length; ++i) {
            this.listeners[i].sessionStarting(context, flow, input);
        }
    }

    public void fireSessionStarted(RequestContext context, FlowSession session) {
        for (int i = 0; i < this.listeners.length; ++i) {
            this.listeners[i].sessionStarted(context, session);
        }
    }

    public void fireEventSignaled(RequestContext context, Event event) {
        for (int i = 0; i < this.listeners.length; ++i) {
            this.listeners[i].eventSignaled(context, event);
        }
    }

    public void fireStateEntering(RequestContext context, State nextState) {
        for (int i = 0; i < this.listeners.length; ++i) {
            this.listeners[i].stateEntering(context, nextState);
        }
    }

    public void fireStateEntered(RequestContext context, State previousState) {
        for (int i = 0; i < this.listeners.length; ++i) {
            this.listeners[i].stateEntered(context, previousState, context.getCurrentState());
        }
    }

    public void fireResumed(RequestContext context) {
        for (int i = 0; i < this.listeners.length; ++i) {
            this.listeners[i].resumed(context);
        }
    }

    public void firePaused(RequestContext context, ViewSelection selectedView) {
        for (int i = 0; i < this.listeners.length; ++i) {
            this.listeners[i].paused(context, selectedView);
        }
    }

    public void fireSessionEnding(RequestContext context, FlowSession session, AttributeMap output) {
        for (int i = 0; i < this.listeners.length; ++i) {
            this.listeners[i].sessionEnding(context, session, output);
        }
    }

    public void fireSessionEnded(RequestContext context, FlowSession session, UnmodifiableAttributeMap output) {
        for (int i = 0; i < this.listeners.length; ++i) {
            this.listeners[i].sessionEnded(context, session, output);
        }
    }
}

