/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.execution.impl;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.style.ToStringCreator;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.webflow.AttributeMap;
import org.springframework.webflow.Flow;
import org.springframework.webflow.FlowSession;
import org.springframework.webflow.FlowSessionStatus;
import org.springframework.webflow.State;
import org.springframework.webflow.execution.FlowLocator;

class FlowSessionImpl
implements FlowSession,
Externalizable {
    private static final Log logger = LogFactory.getLog((Class)(class$org$springframework$webflow$execution$impl$FlowSessionImpl == null ? (class$org$springframework$webflow$execution$impl$FlowSessionImpl = FlowSessionImpl.class$("org.springframework.webflow.execution.impl.FlowSessionImpl")) : class$org$springframework$webflow$execution$impl$FlowSessionImpl));
    private transient Flow flow;
    private String flowId;
    private transient State state;
    private String stateId;
    private FlowSessionStatus status = FlowSessionStatus.CREATED;
    private AttributeMap scope = new AttributeMap();
    private FlowSessionImpl parent;
    static /* synthetic */ Class class$org$springframework$webflow$execution$impl$FlowSessionImpl;

    public FlowSessionImpl() {
    }

    public FlowSessionImpl(Flow flow, FlowSessionImpl parent) {
        Assert.notNull((Object)flow, (String)"The flow is required");
        this.flow = flow;
        this.parent = parent;
    }

    public Flow getFlow() {
        return this.flow;
    }

    public State getState() {
        return this.state;
    }

    public void setState(State state) {
        Assert.notNull((Object)state, (String)"The state is required");
        Assert.isTrue((this.flow == state.getFlow() ? 1 : 0) != 0, (String)"The state does not belong to the flow associated with this flow session");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Setting current state of '" + this.getFlow().getId() + "@" + ObjectUtils.getIdentityHexString((Object)this) + "' to '" + state.getId() + "'"));
        }
        this.state = state;
    }

    public FlowSessionStatus getStatus() {
        return this.status;
    }

    protected void setStatus(FlowSessionStatus status) {
        Assert.notNull((Object)((Object)status));
        this.status = status;
    }

    public AttributeMap getScope() {
        return this.scope;
    }

    public FlowSession getParent() {
        return this.parent;
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.flowId = (String)in.readObject();
        this.stateId = (String)in.readObject();
        this.status = (FlowSessionStatus)((Object)in.readObject());
        this.scope = (AttributeMap)in.readObject();
        this.parent = (FlowSessionImpl)in.readObject();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        if (this.flow != null) {
            out.writeObject(this.flow.getId());
        } else {
            out.writeObject(this.flowId);
        }
        if (this.state != null) {
            out.writeObject(this.state.getId());
        } else {
            out.writeObject(this.stateId);
        }
        out.writeObject((Object)this.status);
        out.writeObject(this.scope);
        out.writeObject(this.parent);
    }

    protected void rehydrate(FlowLocator flowLocator) {
        Assert.state((this.flow == null ? 1 : 0) != 0, (String)"The flow is already set -- already restored");
        Assert.state((this.state == null ? 1 : 0) != 0, (String)"The state is already set -- already restored");
        Assert.notNull((Object)this.flowId, (String)"The flow id was not set during deserialization: cannot restore; was this flow session deserialized properly?");
        this.flow = flowLocator.getFlow(this.flowId);
        this.flowId = null;
        Assert.notNull((Object)this.stateId, (String)"The current state id was not set during deserialization: cannot restore; was this flow session deserialized properly?");
        this.state = this.flow.getRequiredState(this.stateId);
        this.stateId = null;
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("flow", (Object)this.flow.getId()).append("state", (Object)(this.state != null ? this.state.getId() : "[none]")).append("scope", (Object)this.scope).toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

