/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.execution.repository.continuation;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import org.apache.commons.codec.binary.Base64;
import org.springframework.util.Assert;
import org.springframework.webflow.AttributeMap;
import org.springframework.webflow.execution.FlowExecution;
import org.springframework.webflow.execution.repository.FlowExecutionKey;
import org.springframework.webflow.execution.repository.FlowExecutionRestorationFailureException;
import org.springframework.webflow.execution.repository.continuation.ContinuationUnmarshalException;
import org.springframework.webflow.execution.repository.continuation.FlowExecutionContinuation;
import org.springframework.webflow.execution.repository.continuation.FlowExecutionContinuationFactory;
import org.springframework.webflow.execution.repository.continuation.SerializedFlowExecutionContinuationFactory;
import org.springframework.webflow.execution.repository.conversation.Conversation;
import org.springframework.webflow.execution.repository.conversation.ConversationId;
import org.springframework.webflow.execution.repository.conversation.ConversationParameters;
import org.springframework.webflow.execution.repository.conversation.ConversationService;
import org.springframework.webflow.execution.repository.conversation.ConversationServiceException;
import org.springframework.webflow.execution.repository.conversation.NoSuchConversationException;
import org.springframework.webflow.execution.repository.conversation.impl.SimpleConversationId;
import org.springframework.webflow.execution.repository.support.AbstractConversationFlowExecutionRepository;
import org.springframework.webflow.execution.repository.support.FlowExecutionRepositoryServices;

public class ClientContinuationFlowExecutionRepository
extends AbstractConversationFlowExecutionRepository {
    private FlowExecutionContinuationFactory continuationFactory = new SerializedFlowExecutionContinuationFactory();

    public ClientContinuationFlowExecutionRepository(FlowExecutionRepositoryServices repositoryServices) {
        super(repositoryServices, new NoOpConversationService());
    }

    public ClientContinuationFlowExecutionRepository(FlowExecutionRepositoryServices repositoryServices, ConversationService conversationService) {
        super(repositoryServices, conversationService);
    }

    public FlowExecutionContinuationFactory getContinuationFactory() {
        return this.continuationFactory;
    }

    public void setContinuationFactory(FlowExecutionContinuationFactory continuationFactory) {
        Assert.notNull((Object)continuationFactory, (String)"The continuation factory is required");
        this.continuationFactory = continuationFactory;
    }

    public FlowExecution getFlowExecution(FlowExecutionKey key) {
        FlowExecutionContinuation continuation = (FlowExecutionContinuation)this.getContinuationId(key);
        try {
            FlowExecution flowExecution = continuation.unmarshal();
            return this.rehydrate(flowExecution, key);
        }
        catch (ContinuationUnmarshalException e) {
            throw new FlowExecutionRestorationFailureException(key, (Exception)((Object)e));
        }
    }

    public void putFlowExecution(FlowExecutionKey key, FlowExecution flowExecution) {
        this.putConversationScope(key, this.asImpl(flowExecution).getConversationScope());
    }

    protected final Serializable generateContinuationId(FlowExecution flowExecution) {
        return this.encode(flowExecution);
    }

    protected final Serializable parseContinuationId(String encodedId) {
        return this.decode(encodedId);
    }

    protected Serializable encode(FlowExecution flowExecution) {
        FlowExecutionContinuation continuation = this.continuationFactory.createContinuation(flowExecution);
        return new String(Base64.encodeBase64((byte[])continuation.toByteArray()));
    }

    protected FlowExecutionContinuation decode(String encodedContinuation) {
        byte[] bytes = Base64.decodeBase64((byte[])encodedContinuation.getBytes());
        try {
            return this.deserializeContinuation(bytes);
        }
        catch (IOException e) {
            throw new ContinuationUnmarshalException("This should not happen", e);
        }
        catch (ClassNotFoundException e) {
            throw new ContinuationUnmarshalException("This should not happen", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FlowExecutionContinuation deserializeContinuation(byte[] bytes) throws IOException, ClassNotFoundException {
        ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(bytes));
        try {
            FlowExecutionContinuation flowExecutionContinuation = (FlowExecutionContinuation)ois.readObject();
            return flowExecutionContinuation;
        }
        finally {
            ois.close();
        }
    }

    private static class NoOpConversationService
    implements ConversationService {
        private static final ConversationId conversationId = new SimpleConversationId((Serializable)((Object)"1"));
        private static final NoOpConversation INSTANCE = new NoOpConversation();

        private NoOpConversationService() {
        }

        public Conversation beginConversation(ConversationParameters conversationParameters) throws ConversationServiceException {
            return INSTANCE;
        }

        public Conversation getConversation(ConversationId id) throws NoSuchConversationException {
            return INSTANCE;
        }

        public ConversationId parseConversationId(String encodedId) throws ConversationServiceException {
            return conversationId;
        }

        private static class NoOpConversation
        implements Conversation {
            private NoOpConversation() {
            }

            public void end() {
            }

            public Object getAttribute(Object name) {
                return new AttributeMap();
            }

            public ConversationId getId() {
                return conversationId;
            }

            public void lock() {
            }

            public void putAttribute(Object name, Object value) {
            }

            public void removeAttribute(Object name) {
            }

            public void unlock() {
            }
        }
    }
}

