/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.execution.repository.continuation;

import java.io.Serializable;
import org.springframework.util.Assert;
import org.springframework.webflow.execution.FlowExecution;
import org.springframework.webflow.execution.repository.FlowExecutionKey;
import org.springframework.webflow.execution.repository.FlowExecutionRestorationFailureException;
import org.springframework.webflow.execution.repository.continuation.ContinuationNotFoundException;
import org.springframework.webflow.execution.repository.continuation.ContinuationUnmarshalException;
import org.springframework.webflow.execution.repository.continuation.FlowExecutionContinuation;
import org.springframework.webflow.execution.repository.continuation.FlowExecutionContinuationFactory;
import org.springframework.webflow.execution.repository.continuation.FlowExecutionContinuationGroup;
import org.springframework.webflow.execution.repository.continuation.SerializedFlowExecutionContinuationFactory;
import org.springframework.webflow.execution.repository.conversation.Conversation;
import org.springframework.webflow.execution.repository.conversation.ConversationService;
import org.springframework.webflow.execution.repository.conversation.impl.LocalConversationService;
import org.springframework.webflow.execution.repository.support.AbstractConversationFlowExecutionRepository;
import org.springframework.webflow.execution.repository.support.FlowExecutionRepositoryServices;
import org.springframework.webflow.util.RandomGuidUidGenerator;
import org.springframework.webflow.util.UidGenerator;

public class ContinuationFlowExecutionRepository
extends AbstractConversationFlowExecutionRepository
implements Serializable {
    private static final String CONTINUATION_GROUP_ATTRIBUTE = "continuationGroup";
    private transient FlowExecutionContinuationFactory continuationFactory = new SerializedFlowExecutionContinuationFactory();
    private transient UidGenerator continuationIdGenerator = new RandomGuidUidGenerator();
    private int maxContinuations;

    public ContinuationFlowExecutionRepository(FlowExecutionRepositoryServices repositoryServices) {
        super(repositoryServices, new LocalConversationService());
    }

    public ContinuationFlowExecutionRepository(FlowExecutionRepositoryServices repositoryServices, ConversationService conversationService) {
        super(repositoryServices, conversationService);
    }

    public FlowExecutionContinuationFactory getContinuationFactory() {
        return this.continuationFactory;
    }

    public void setContinuationFactory(FlowExecutionContinuationFactory continuationFactory) {
        Assert.notNull((Object)continuationFactory, (String)"The continuation factory is required");
        this.continuationFactory = continuationFactory;
    }

    public UidGenerator getContinuationIdGenerator() {
        return this.continuationIdGenerator;
    }

    public void setContinuationIdGenerator(UidGenerator continuationIdGenerator) {
        Assert.notNull((Object)continuationIdGenerator, (String)"The continuation id generator is required");
        this.continuationIdGenerator = continuationIdGenerator;
    }

    public int getMaxContinuations() {
        return this.maxContinuations;
    }

    public void setMaxContinuations(int maxContinuations) {
        Assert.isTrue((maxContinuations >= 0 ? 1 : 0) != 0, (String)"The max continuations must be greater than or equal to 0");
        this.maxContinuations = maxContinuations;
    }

    protected void onBegin(Conversation conversation) {
        FlowExecutionContinuationGroup continuationGroup = new FlowExecutionContinuationGroup(this.maxContinuations);
        conversation.putAttribute(CONTINUATION_GROUP_ATTRIBUTE, continuationGroup);
    }

    public FlowExecution getFlowExecution(FlowExecutionKey key) {
        FlowExecutionContinuation continuation = this.getContinuation(key);
        try {
            FlowExecution flowExecution = continuation.unmarshal();
            return this.rehydrate(flowExecution, key);
        }
        catch (ContinuationUnmarshalException e) {
            throw new FlowExecutionRestorationFailureException(key, (Exception)((Object)e));
        }
    }

    public void putFlowExecution(FlowExecutionKey key, FlowExecution flowExecution) {
        FlowExecutionContinuationGroup continuationGroup = this.getContinuationGroup(key);
        FlowExecutionContinuation continuation = this.continuationFactory.createContinuation(flowExecution);
        continuationGroup.add(this.getContinuationId(key), continuation);
        this.putConversationScope(key, this.asImpl(flowExecution).getConversationScope());
    }

    protected FlowExecutionContinuationGroup getContinuationGroup(FlowExecutionKey key) {
        FlowExecutionContinuationGroup group = (FlowExecutionContinuationGroup)this.getConversation(key).getAttribute(CONTINUATION_GROUP_ATTRIBUTE);
        return group;
    }

    protected FlowExecutionContinuation getContinuation(FlowExecutionKey key) {
        try {
            return this.getContinuationGroup(key).get(this.getContinuationId(key));
        }
        catch (ContinuationNotFoundException e) {
            throw new FlowExecutionRestorationFailureException(key, (Exception)((Object)e));
        }
    }

    protected Serializable generateContinuationId(FlowExecution flowExecution) {
        return this.continuationIdGenerator.generateUid();
    }

    protected Serializable parseContinuationId(String encodedId) {
        return this.continuationIdGenerator.parseUid(encodedId);
    }
}

