/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.execution.repository.continuation;

import org.springframework.util.Assert;
import org.springframework.webflow.execution.FlowLocator;
import org.springframework.webflow.execution.repository.FlowExecutionRepository;
import org.springframework.webflow.execution.repository.continuation.ContinuationFlowExecutionRepository;
import org.springframework.webflow.execution.repository.continuation.FlowExecutionContinuationFactory;
import org.springframework.webflow.execution.repository.continuation.SerializedFlowExecutionContinuationFactory;
import org.springframework.webflow.execution.repository.support.AbstractFlowExecutionRepositoryCreator;
import org.springframework.webflow.execution.repository.support.DelegatingFlowExecutionRepositoryFactory;
import org.springframework.webflow.execution.repository.support.FlowExecutionRepositoryServices;
import org.springframework.webflow.execution.repository.support.SharedMapFlowExecutionRepositoryFactory;
import org.springframework.webflow.util.RandomGuidUidGenerator;
import org.springframework.webflow.util.UidGenerator;

public class ContinuationFlowExecutionRepositoryFactory
extends DelegatingFlowExecutionRepositoryFactory {
    public ContinuationFlowExecutionRepositoryFactory(FlowLocator flowLocator) {
        super(flowLocator);
        this.setRepositoryFactory(new SharedMapFlowExecutionRepositoryFactory(new ContinuationFlowExecutionRepositoryCreator(this)));
    }

    protected ContinuationFlowExecutionRepositoryCreator getRepositoryCreator() {
        SharedMapFlowExecutionRepositoryFactory factory = (SharedMapFlowExecutionRepositoryFactory)this.getRepositoryFactory();
        return (ContinuationFlowExecutionRepositoryCreator)factory.getRepositoryCreator();
    }

    public void setContinuationFactory(FlowExecutionContinuationFactory continuationFactory) {
        this.getRepositoryCreator().setContinuationFactory(continuationFactory);
    }

    public void setContinuationIdGenerator(UidGenerator continuationIdGenerator) {
        this.getRepositoryCreator().setContinuationIdGenerator(continuationIdGenerator);
    }

    public void setMaxContinuations(int maxContinuations) {
        this.getRepositoryCreator().setMaxContinuations(maxContinuations);
    }

    private static class ContinuationFlowExecutionRepositoryCreator
    extends AbstractFlowExecutionRepositoryCreator {
        private FlowExecutionContinuationFactory continuationFactory = new SerializedFlowExecutionContinuationFactory();
        private transient UidGenerator continuationIdGenerator = new RandomGuidUidGenerator();
        private int maxContinuations;

        public ContinuationFlowExecutionRepositoryCreator(FlowExecutionRepositoryServices repositoryServices) {
            super(repositoryServices);
        }

        public void setContinuationFactory(FlowExecutionContinuationFactory continuationFactory) {
            Assert.notNull((Object)continuationFactory, (String)"The continuation factory is required");
            this.continuationFactory = continuationFactory;
        }

        public void setContinuationIdGenerator(UidGenerator continuationIdGenerator) {
            Assert.notNull((Object)continuationIdGenerator, (String)"The continuation id generator is required");
            this.continuationIdGenerator = continuationIdGenerator;
        }

        public void setMaxContinuations(int maxContinuations) {
            this.maxContinuations = maxContinuations;
        }

        public FlowExecutionRepository createRepository() {
            ContinuationFlowExecutionRepository repository = new ContinuationFlowExecutionRepository(this.getRepositoryServices());
            repository.setContinuationFactory(this.continuationFactory);
            repository.setMaxContinuations(this.maxContinuations);
            repository.setContinuationIdGenerator(this.continuationIdGenerator);
            return repository;
        }

        public FlowExecutionRepository rehydrateRepository(FlowExecutionRepository repository) {
            ContinuationFlowExecutionRepository impl = (ContinuationFlowExecutionRepository)repository;
            impl.setRepositoryServices(this.getRepositoryServices());
            impl.setContinuationFactory(this.continuationFactory);
            impl.setContinuationIdGenerator(this.continuationIdGenerator);
            return impl;
        }
    }
}

