/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.execution.repository.continuation;

import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.springframework.webflow.execution.repository.continuation.ContinuationNotFoundException;
import org.springframework.webflow.execution.repository.continuation.FlowExecutionContinuation;

class FlowExecutionContinuationGroup
implements Serializable {
    private Map continuations = new HashMap();
    private LinkedList continuationIds = new LinkedList();
    private int maxContinuations;

    public FlowExecutionContinuationGroup(int maxContinuations) {
        this.maxContinuations = maxContinuations;
    }

    public int getContinuationCount() {
        return this.continuationIds.size();
    }

    public FlowExecutionContinuation get(Serializable id) throws ContinuationNotFoundException {
        FlowExecutionContinuation continuation = (FlowExecutionContinuation)this.continuations.get(id);
        if (continuation == null) {
            throw new ContinuationNotFoundException(id);
        }
        return continuation;
    }

    public void add(Serializable continuationId, FlowExecutionContinuation continuation) {
        this.continuations.put(continuationId, continuation);
        this.continuationIds.add(continuationId);
        if (this.maxExceeded()) {
            this.removeOldestContinuation();
        }
    }

    private boolean maxExceeded() {
        return this.maxContinuations > 0 && this.continuationIds.size() > this.maxContinuations;
    }

    private void removeOldestContinuation() {
        this.continuations.remove(this.continuationIds.removeFirst());
    }
}

