/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.execution.repository.continuation;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import org.springframework.util.FileCopyUtils;
import org.springframework.webflow.execution.FlowExecution;
import org.springframework.webflow.execution.repository.continuation.ContinuationUnmarshalException;
import org.springframework.webflow.execution.repository.continuation.FlowExecutionContinuation;

class SerializedFlowExecutionContinuation
extends FlowExecutionContinuation {
    private byte[] data;
    private boolean compressed;

    public SerializedFlowExecutionContinuation(byte[] data, boolean compressed) {
        this.data = data;
        this.compressed = compressed;
    }

    public boolean isCompressed() {
        return this.compressed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FlowExecution unmarshal() throws ContinuationUnmarshalException {
        FlowExecution flowExecution;
        ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(this.getData(true)));
        try {
            flowExecution = (FlowExecution)ois.readObject();
        }
        catch (Throwable throwable) {
            try {
                ois.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new ContinuationUnmarshalException("IOException thrown deserializing the flow execution stored in this continuation -- this should not happen!", e);
            }
            catch (ClassNotFoundException e) {
                throw new ContinuationUnmarshalException("ClassNotFoundException thrown deserializing the flow execution stored in this continuation -- This should not happen! Make sure there are no classloader issues.For example, perhaps the Web Flow system is being loaded by a classloader that is a parent of the classloader loading application classes?", e);
            }
        }
        ois.close();
        return flowExecution;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] toByteArray() {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(this.data.length + 128);
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            try {
                oos.writeObject(this);
                oos.flush();
            }
            finally {
                oos.close();
            }
            return baos.toByteArray();
        }
        catch (IOException e) {
            throw new IllegalStateException();
        }
    }

    public byte[] getData(boolean decompress) throws IOException {
        if (this.isCompressed() && decompress) {
            return this.decompress(this.data);
        }
        return this.data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] decompress(byte[] dataToDecompress) throws IOException {
        GZIPInputStream gzipin = new GZIPInputStream(new ByteArrayInputStream(dataToDecompress));
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            FileCopyUtils.copy((InputStream)gzipin, (OutputStream)baos);
        }
        finally {
            gzipin.close();
        }
        return baos.toByteArray();
    }
}

