/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.execution.repository.continuation;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectOutputStream;
import java.util.zip.GZIPOutputStream;
import org.springframework.webflow.execution.FlowExecution;
import org.springframework.webflow.execution.repository.continuation.ContinuationCreationException;
import org.springframework.webflow.execution.repository.continuation.FlowExecutionContinuation;
import org.springframework.webflow.execution.repository.continuation.FlowExecutionContinuationFactory;
import org.springframework.webflow.execution.repository.continuation.SerializedFlowExecutionContinuation;

public class SerializedFlowExecutionContinuationFactory
implements FlowExecutionContinuationFactory {
    private boolean compress = true;

    public boolean getCompress() {
        return this.compress;
    }

    public void setCompress(boolean compress) {
        this.compress = compress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FlowExecutionContinuation createContinuation(FlowExecution flowExecution) throws ContinuationCreationException {
        SerializedFlowExecutionContinuation serializedFlowExecutionContinuation;
        ByteArrayOutputStream baos = new ByteArrayOutputStream(384);
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        try {
            oos.writeObject(flowExecution);
            oos.flush();
            byte[] data = baos.toByteArray();
            if (this.compress) {
                data = this.compress(data);
            }
            serializedFlowExecutionContinuation = new SerializedFlowExecutionContinuation(data, this.compress);
        }
        catch (Throwable throwable) {
            try {
                oos.close();
                throw throwable;
            }
            catch (NotSerializableException e) {
                throw new ContinuationCreationException(flowExecution, "Could not serialize flow execution; make sure all objects stored in flow scope are serializable", e);
            }
            catch (IOException e) {
                throw new ContinuationCreationException(flowExecution, "IOException thrown serializing flow execution -- this should not happen!", e);
            }
        }
        oos.close();
        return serializedFlowExecutionContinuation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] compress(byte[] dataToCompress) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        GZIPOutputStream gzipos = new GZIPOutputStream(baos);
        try {
            gzipos.write(dataToCompress);
            gzipos.flush();
        }
        finally {
            gzipos.close();
        }
        return baos.toByteArray();
    }
}

