/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.execution.repository.conversation.impl;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.springframework.core.style.ToStringCreator;
import org.springframework.webflow.execution.repository.conversation.ConversationId;
import org.springframework.webflow.execution.repository.conversation.impl.ConversationLock;
import org.springframework.webflow.execution.repository.conversation.impl.ConversationLockFactory;

class ConversationEntry
implements Serializable {
    private ConversationId id;
    private String name;
    private String caption;
    private String description;
    private transient ConversationLock lock = ConversationLockFactory.createLock();
    private Map attributes = new HashMap();

    public ConversationEntry(ConversationId id, String name, String caption, String description) {
        this.id = id;
        this.name = name;
        this.caption = caption;
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public String getCaption() {
        return this.caption;
    }

    public Map getAttributes() {
        return this.attributes;
    }

    public String getDescription() {
        return this.description;
    }

    public ConversationId getId() {
        return this.id;
    }

    public ConversationLock getLock() {
        return this.lock;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ConversationEntry)) {
            return false;
        }
        return this.id.equals(((ConversationEntry)o).id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.lock = ConversationLockFactory.createLock();
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("id", (Object)this.id).append("caption", (Object)this.caption).append("lock", (Object)this.lock).toString();
    }
}

