/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.execution.repository.conversation.impl;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.springframework.util.Assert;
import org.springframework.webflow.execution.repository.conversation.Conversation;
import org.springframework.webflow.execution.repository.conversation.ConversationId;
import org.springframework.webflow.execution.repository.conversation.ConversationParameters;
import org.springframework.webflow.execution.repository.conversation.ConversationService;
import org.springframework.webflow.execution.repository.conversation.NoSuchConversationException;
import org.springframework.webflow.execution.repository.conversation.impl.ConversationEntry;
import org.springframework.webflow.execution.repository.conversation.impl.ConversationLock;
import org.springframework.webflow.execution.repository.conversation.impl.SimpleConversationId;
import org.springframework.webflow.util.RandomGuidUidGenerator;
import org.springframework.webflow.util.UidGenerator;

public class LocalConversationService
implements ConversationService,
Serializable {
    private Map conversations = new HashMap();
    private UidGenerator conversationIdGenerator = new RandomGuidUidGenerator();

    protected UidGenerator getConversationIdGenerator() {
        return this.conversationIdGenerator;
    }

    public void setConversationIdGenerator(UidGenerator uidGenerator) {
        this.conversationIdGenerator = uidGenerator;
    }

    public Conversation beginConversation(ConversationParameters conversationParameters) {
        Assert.notNull((Object)conversationParameters, (String)"newConversation must not be null");
        SimpleConversationId conversationId = new SimpleConversationId(this.conversationIdGenerator.generateUid());
        this.conversations.put(conversationId, this.createConversation(conversationParameters, conversationId));
        return this.getConversation(conversationId);
    }

    public Conversation getConversation(ConversationId id) throws NoSuchConversationException {
        if (!this.conversations.containsKey(id)) {
            throw new NoSuchConversationException(id);
        }
        return new ConversationProxy(id);
    }

    public ConversationId parseConversationId(String conversationId) {
        return new SimpleConversationId(this.conversationIdGenerator.parseUid(conversationId));
    }

    private ConversationEntry createConversation(ConversationParameters newConversation, ConversationId conversationId) {
        return new ConversationEntry(conversationId, newConversation.getName(), newConversation.getCaption(), newConversation.getDescription());
    }

    private ConversationLock getLock(ConversationId conversationId) {
        Assert.notNull((Object)conversationId, (String)"conversationId must not be null");
        if (!this.conversations.containsKey(conversationId)) {
            throw new NoSuchConversationException(conversationId);
        }
        return this.getConversationEntry(conversationId).getLock();
    }

    private Object getAttribute(ConversationId conversationId, Object name) {
        Assert.notNull((Object)conversationId, (String)"conversationId must not be null");
        Assert.notNull((Object)name, (String)"name must not be null");
        if (!this.conversations.containsKey(conversationId)) {
            throw new NoSuchConversationException(conversationId);
        }
        return this.getConversationEntry(conversationId).getAttributes().get(name);
    }

    private Object putAttribute(ConversationId conversationId, Object name, Object value) {
        Assert.notNull((Object)conversationId, (String)"conversationId must not be null");
        Assert.notNull((Object)name, (String)"name must not be null");
        if (!this.conversations.containsKey(conversationId)) {
            throw new NoSuchConversationException(conversationId);
        }
        return this.getConversationEntry(conversationId).getAttributes().put(name, value);
    }

    private Object removeAttribute(ConversationId conversationId, Object name) {
        Assert.notNull((Object)conversationId, (String)"conversationId must not be null");
        Assert.notNull((Object)name, (String)"name must not be null");
        if (!this.conversations.containsKey(conversationId)) {
            throw new NoSuchConversationException(conversationId);
        }
        return this.getConversationEntry(conversationId).getAttributes().remove(name);
    }

    private void end(ConversationId conversationId) {
        Assert.notNull((Object)conversationId, (String)"conversationId must not be null");
        if (!this.conversations.containsKey(conversationId)) {
            throw new NoSuchConversationException(conversationId);
        }
        this.conversations.remove(conversationId);
    }

    private ConversationEntry getConversationEntry(ConversationId conversationId) {
        return (ConversationEntry)this.conversations.get(conversationId);
    }

    private class ConversationProxy
    implements Conversation {
        private ConversationId conversationId;

        public ConversationProxy(ConversationId id) {
            this.conversationId = id;
        }

        public ConversationId getId() {
            return this.conversationId;
        }

        public void lock() {
            LocalConversationService.this.getLock(this.conversationId).lock();
        }

        public void end() {
            LocalConversationService.this.end(this.conversationId);
        }

        public Object getAttribute(Object name) {
            return LocalConversationService.this.getAttribute(this.conversationId, name);
        }

        public void putAttribute(Object name, Object value) {
            LocalConversationService.this.putAttribute(this.conversationId, name, value);
        }

        public void removeAttribute(Object name) {
            LocalConversationService.this.removeAttribute(this.conversationId, name);
        }

        public void unlock() {
            LocalConversationService.this.getLock(this.conversationId).unlock();
        }
    }
}

