/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.execution.repository.support;

import java.io.Serializable;
import org.springframework.util.Assert;
import org.springframework.webflow.AttributeMap;
import org.springframework.webflow.Flow;
import org.springframework.webflow.execution.FlowExecution;
import org.springframework.webflow.execution.repository.BadlyFormattedFlowExecutionKeyException;
import org.springframework.webflow.execution.repository.FlowExecutionKey;
import org.springframework.webflow.execution.repository.FlowExecutionLock;
import org.springframework.webflow.execution.repository.FlowExecutionRepositoryException;
import org.springframework.webflow.execution.repository.NoSuchFlowExecutionException;
import org.springframework.webflow.execution.repository.conversation.Conversation;
import org.springframework.webflow.execution.repository.conversation.ConversationId;
import org.springframework.webflow.execution.repository.conversation.ConversationParameters;
import org.springframework.webflow.execution.repository.conversation.ConversationService;
import org.springframework.webflow.execution.repository.conversation.ConversationServiceException;
import org.springframework.webflow.execution.repository.conversation.NoSuchConversationException;
import org.springframework.webflow.execution.repository.support.AbstractFlowExecutionRepository;
import org.springframework.webflow.execution.repository.support.CompositeFlowExecutionKey;
import org.springframework.webflow.execution.repository.support.ConversationBackedFlowExecutionLock;
import org.springframework.webflow.execution.repository.support.FlowExecutionRepositoryServices;

public abstract class AbstractConversationFlowExecutionRepository
extends AbstractFlowExecutionRepository
implements Serializable {
    private static final String SCOPE_ATTRIBUTE = "scope";
    private ConversationService conversationService;

    protected AbstractConversationFlowExecutionRepository() {
    }

    public AbstractConversationFlowExecutionRepository(FlowExecutionRepositoryServices repositoryServices, ConversationService conversationService) {
        this.setRepositoryServices(repositoryServices);
        this.setConversationService(conversationService);
    }

    protected ConversationService getConversationService() {
        return this.conversationService;
    }

    public void setConversationService(ConversationService conversationService) {
        Assert.notNull((Object)conversationService, (String)"The conversation service is required");
        this.conversationService = conversationService;
    }

    public FlowExecutionKey generateKey(FlowExecution flowExecution) {
        Conversation conversation = this.conversationService.beginConversation(this.createNewConversation(flowExecution));
        this.onBegin(conversation);
        return new CompositeFlowExecutionKey(conversation.getId(), this.generateContinuationId(flowExecution));
    }

    public FlowExecutionLock getLock(FlowExecutionKey key) throws FlowExecutionRepositoryException {
        return new ConversationBackedFlowExecutionLock(this.getConversation(key));
    }

    public FlowExecutionKey getNextKey(FlowExecution flowExecution, FlowExecutionKey previousKey) {
        if (this.isAlwaysGenerateNewNextKey()) {
            CompositeFlowExecutionKey key = (CompositeFlowExecutionKey)previousKey;
            return new CompositeFlowExecutionKey(key.getConversationId(), this.generateContinuationId(flowExecution));
        }
        return previousKey;
    }

    public void removeFlowExecution(FlowExecutionKey key) throws FlowExecutionRepositoryException {
        try {
            this.getConversation(key).end();
        }
        catch (NoSuchConversationException e) {
            throw new NoSuchFlowExecutionException(key, (Exception)((Object)e));
        }
    }

    public FlowExecutionKey parseFlowExecutionKey(String encodedKey) throws FlowExecutionRepositoryException {
        Assert.hasText((String)encodedKey, (String)"The string encoded flow execution key is required");
        String[] keyParts = CompositeFlowExecutionKey.keyParts(encodedKey);
        try {
            ConversationId conversationId = this.conversationService.parseConversationId(keyParts[0]);
            return new CompositeFlowExecutionKey(conversationId, this.parseContinuationId(keyParts[1]));
        }
        catch (ConversationServiceException e) {
            throw new BadlyFormattedFlowExecutionKeyException(encodedKey, CompositeFlowExecutionKey.getFormat(), (Throwable)((Object)e));
        }
        catch (FlowExecutionRepositoryException e) {
            throw new BadlyFormattedFlowExecutionKeyException(encodedKey, CompositeFlowExecutionKey.getFormat(), (Throwable)((Object)e));
        }
    }

    protected ConversationParameters createNewConversation(FlowExecution flowExecution) {
        Flow flow = flowExecution.getFlow();
        return new ConversationParameters(flow.getId(), flow.getCaption(), flow.getDescription());
    }

    protected void onBegin(Conversation conversation) {
    }

    protected ConversationId getConversationId(FlowExecutionKey key) {
        return ((CompositeFlowExecutionKey)key).getConversationId();
    }

    protected Serializable getContinuationId(FlowExecutionKey key) {
        return ((CompositeFlowExecutionKey)key).getContinuationId();
    }

    protected Conversation getConversation(FlowExecutionKey key) {
        try {
            return this.getConversationService().getConversation(this.getConversationId(key));
        }
        catch (NoSuchConversationException e) {
            throw new NoSuchFlowExecutionException(key, (Exception)((Object)e));
        }
    }

    protected FlowExecution rehydrate(FlowExecution flowExecution, FlowExecutionKey key) {
        flowExecution = super.rehydrate(flowExecution, key);
        this.asImpl(flowExecution).setConversationScope(this.getConversationScope(key));
        return flowExecution;
    }

    protected AttributeMap getConversationScope(FlowExecutionKey key) {
        return (AttributeMap)this.getConversation(key).getAttribute(SCOPE_ATTRIBUTE);
    }

    protected void putConversationScope(FlowExecutionKey key, AttributeMap scope) {
        this.getConversation(key).putAttribute(SCOPE_ATTRIBUTE, scope);
    }

    protected abstract Serializable generateContinuationId(FlowExecution var1);

    protected abstract Serializable parseContinuationId(String var1) throws FlowExecutionRepositoryException;
}

