/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.execution.repository.support;

import java.io.Serializable;
import org.springframework.util.Assert;
import org.springframework.webflow.Flow;
import org.springframework.webflow.execution.FlowExecution;
import org.springframework.webflow.execution.impl.FlowExecutionImpl;
import org.springframework.webflow.execution.repository.FlowExecutionKey;
import org.springframework.webflow.execution.repository.FlowExecutionLock;
import org.springframework.webflow.execution.repository.FlowExecutionRepository;
import org.springframework.webflow.execution.repository.FlowExecutionRepositoryException;
import org.springframework.webflow.execution.repository.support.FlowExecutionRepositoryServices;

public abstract class AbstractFlowExecutionRepository
implements FlowExecutionRepository,
Serializable {
    private transient FlowExecutionRepositoryServices repositoryServices;
    private boolean alwaysGenerateNewNextKey = true;

    protected AbstractFlowExecutionRepository() {
    }

    public AbstractFlowExecutionRepository(FlowExecutionRepositoryServices repositoryServices) {
        this.setRepositoryServices(repositoryServices);
    }

    protected FlowExecutionRepositoryServices getRepositoryServices() {
        return this.repositoryServices;
    }

    public void setRepositoryServices(FlowExecutionRepositoryServices repositoryServices) {
        Assert.notNull((Object)repositoryServices, (String)"The repository services instance is required");
        this.repositoryServices = repositoryServices;
    }

    protected boolean isAlwaysGenerateNewNextKey() {
        return this.alwaysGenerateNewNextKey;
    }

    public void setAlwaysGenerateNewNextKey(boolean alwaysGenerateNewNextKey) {
        this.alwaysGenerateNewNextKey = alwaysGenerateNewNextKey;
    }

    public FlowExecution createFlowExecution(String flowId) {
        Flow flow = this.repositoryServices.getFlowLocator().getFlow(flowId);
        return new FlowExecutionImpl(flow, this.repositoryServices.getListenerLoader().getListeners(flow));
    }

    public abstract FlowExecutionKey generateKey(FlowExecution var1) throws FlowExecutionRepositoryException;

    public abstract FlowExecutionKey parseFlowExecutionKey(String var1);

    public abstract FlowExecution getFlowExecution(FlowExecutionKey var1) throws FlowExecutionRepositoryException;

    public abstract FlowExecutionLock getLock(FlowExecutionKey var1) throws FlowExecutionRepositoryException;

    public abstract FlowExecutionKey getNextKey(FlowExecution var1, FlowExecutionKey var2) throws FlowExecutionRepositoryException;

    public abstract void putFlowExecution(FlowExecutionKey var1, FlowExecution var2) throws FlowExecutionRepositoryException;

    public abstract void removeFlowExecution(FlowExecutionKey var1) throws FlowExecutionRepositoryException;

    protected FlowExecution rehydrate(FlowExecution flowExecution, FlowExecutionKey key) {
        FlowExecutionImpl impl = this.asImpl(flowExecution);
        impl.rehydrate(this.repositoryServices.getFlowLocator(), this.repositoryServices.getListenerLoader());
        return flowExecution;
    }

    protected FlowExecutionImpl asImpl(FlowExecution flowExecution) {
        return (FlowExecutionImpl)flowExecution;
    }
}

