/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.execution.repository.support;

import java.io.Serializable;
import org.springframework.util.Assert;
import org.springframework.webflow.execution.repository.BadlyFormattedFlowExecutionKeyException;
import org.springframework.webflow.execution.repository.FlowExecutionKey;
import org.springframework.webflow.execution.repository.conversation.ConversationId;

class CompositeFlowExecutionKey
extends FlowExecutionKey {
    private static final String CONVERSATION_ID_PREFIX = "_c";
    private static final String CONTINUATION_ID_PREFIX = "_k";
    private ConversationId conversationId;
    private Serializable continuationId;

    public CompositeFlowExecutionKey(ConversationId conversationId, Serializable continuationId) {
        Assert.notNull((Object)conversationId, (String)"The conversation id is required");
        Assert.notNull((Object)continuationId, (String)"The continuation id is required");
        this.conversationId = conversationId;
        this.continuationId = continuationId;
    }

    public ConversationId getConversationId() {
        return this.conversationId;
    }

    public Serializable getContinuationId() {
        return this.continuationId;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CompositeFlowExecutionKey)) {
            return false;
        }
        CompositeFlowExecutionKey other = (CompositeFlowExecutionKey)obj;
        return this.conversationId.equals(other.conversationId) && this.continuationId.equals(other.continuationId);
    }

    public int hashCode() {
        return this.conversationId.hashCode() + this.continuationId.hashCode();
    }

    public static String[] keyParts(String encodedKey) throws BadlyFormattedFlowExecutionKeyException {
        if (!encodedKey.startsWith(CONVERSATION_ID_PREFIX)) {
            throw new BadlyFormattedFlowExecutionKeyException(encodedKey, CompositeFlowExecutionKey.getFormat());
        }
        int continuationStart = encodedKey.indexOf(CONTINUATION_ID_PREFIX, CONVERSATION_ID_PREFIX.length());
        if (continuationStart == -1) {
            throw new BadlyFormattedFlowExecutionKeyException(encodedKey, CompositeFlowExecutionKey.getFormat());
        }
        String conversationId = encodedKey.substring(CONVERSATION_ID_PREFIX.length(), continuationStart);
        String continuationId = encodedKey.substring(continuationStart + CONTINUATION_ID_PREFIX.length());
        return new String[]{conversationId, continuationId};
    }

    static String getFormat() {
        return "_c<conversationId>_k<continuationId>";
    }

    public String toString() {
        return CONVERSATION_ID_PREFIX + this.getConversationId() + CONTINUATION_ID_PREFIX + this.getContinuationId();
    }
}

