/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.execution.repository.support;

import java.io.Serializable;
import org.springframework.util.Assert;
import org.springframework.webflow.execution.FlowExecution;
import org.springframework.webflow.execution.repository.FlowExecutionKey;
import org.springframework.webflow.execution.repository.PermissionDeniedFlowExecutionAccessException;
import org.springframework.webflow.execution.repository.conversation.ConversationService;
import org.springframework.webflow.execution.repository.conversation.impl.LocalConversationService;
import org.springframework.webflow.execution.repository.support.AbstractConversationFlowExecutionRepository;
import org.springframework.webflow.execution.repository.support.FlowExecutionRepositoryServices;
import org.springframework.webflow.execution.repository.support.InvalidContinuationIdException;
import org.springframework.webflow.util.RandomGuidUidGenerator;
import org.springframework.webflow.util.UidGenerator;

public class DefaultFlowExecutionRepository
extends AbstractConversationFlowExecutionRepository
implements Serializable {
    private static final String FLOW_EXECUTION_ENTRY_ATTRIBUTE = "flowExecutionEntry";
    private transient UidGenerator continuationIdGenerator = new RandomGuidUidGenerator();

    public DefaultFlowExecutionRepository(FlowExecutionRepositoryServices repositoryServices) {
        super(repositoryServices, new LocalConversationService());
    }

    public DefaultFlowExecutionRepository(FlowExecutionRepositoryServices repositoryServices, ConversationService conversationService) {
        super(repositoryServices, conversationService);
    }

    public UidGenerator getContinuationIdGenerator() {
        return this.continuationIdGenerator;
    }

    public void setContinuationIdGenerator(UidGenerator continuationIdGenerator) {
        Assert.notNull((Object)continuationIdGenerator, (String)"The continuation id generator is required");
        this.continuationIdGenerator = continuationIdGenerator;
    }

    public FlowExecution getFlowExecution(FlowExecutionKey key) {
        FlowExecution flowExecution = this.accessFlowExecution(key);
        return this.rehydrate(flowExecution, key);
    }

    public void putFlowExecution(FlowExecutionKey key, FlowExecution flowExecution) {
        FlowExecutionEntry entry = new FlowExecutionEntry(this.getContinuationId(key), flowExecution);
        this.putEntry(key, entry);
        this.putConversationScope(key, this.asImpl(flowExecution).getConversationScope());
    }

    protected Serializable generateContinuationId(FlowExecution flowExecution) {
        return this.continuationIdGenerator.generateUid();
    }

    protected Serializable parseContinuationId(String encodedId) {
        return this.continuationIdGenerator.parseUid(encodedId);
    }

    private FlowExecutionEntry getEntry(FlowExecutionKey key) {
        FlowExecutionEntry entry = (FlowExecutionEntry)this.getConversation(key).getAttribute(FLOW_EXECUTION_ENTRY_ATTRIBUTE);
        if (entry == null) {
            throw new IllegalStateException("No 'flowExecutionEntry' attribute present in conversation scope: possible programmer error--do not call get before calling put");
        }
        return entry;
    }

    private FlowExecution accessFlowExecution(FlowExecutionKey key) {
        try {
            return this.getEntry(key).access(this.getContinuationId(key));
        }
        catch (InvalidContinuationIdException e) {
            throw new PermissionDeniedFlowExecutionAccessException(key, (Exception)((Object)e));
        }
    }

    private void putEntry(FlowExecutionKey key, FlowExecutionEntry entry) {
        this.getConversation(key).putAttribute(FLOW_EXECUTION_ENTRY_ATTRIBUTE, entry);
    }

    private static class FlowExecutionEntry
    implements Serializable {
        private Serializable continuationId;
        private FlowExecution flowExecution;

        public FlowExecutionEntry(Serializable continuationId, FlowExecution flowExecution) {
            this.continuationId = continuationId;
            this.flowExecution = flowExecution;
        }

        public FlowExecution access(Serializable continuationId) throws InvalidContinuationIdException {
            if (!this.continuationId.equals(continuationId)) {
                throw new InvalidContinuationIdException(continuationId);
            }
            return this.flowExecution;
        }
    }
}

