/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.execution.repository.support;

import org.springframework.util.Assert;
import org.springframework.webflow.execution.FlowLocator;
import org.springframework.webflow.execution.repository.FlowExecutionRepository;
import org.springframework.webflow.execution.repository.support.AbstractFlowExecutionRepositoryCreator;
import org.springframework.webflow.execution.repository.support.DefaultFlowExecutionRepository;
import org.springframework.webflow.execution.repository.support.DelegatingFlowExecutionRepositoryFactory;
import org.springframework.webflow.execution.repository.support.FlowExecutionRepositoryServices;
import org.springframework.webflow.execution.repository.support.SharedMapFlowExecutionRepositoryFactory;
import org.springframework.webflow.util.RandomGuidUidGenerator;
import org.springframework.webflow.util.UidGenerator;

public class DefaultFlowExecutionRepositoryFactory
extends DelegatingFlowExecutionRepositoryFactory {
    public DefaultFlowExecutionRepositoryFactory(FlowLocator flowLocator) {
        super(flowLocator);
        this.setRepositoryFactory(new SharedMapFlowExecutionRepositoryFactory(new DefaultFlowExecutionRepositoryCreator(this)));
    }

    public void setContinuationIdGenerator(UidGenerator continuationIdGenerator) {
        this.getRepositoryCreator().setContinuationIdGenerator(continuationIdGenerator);
    }

    public void setAlwaysGenerateNewNextKey(boolean alwaysGenerateNewNextKey) {
        this.getRepositoryCreator().setAlwaysGenerateNewNextKey(alwaysGenerateNewNextKey);
    }

    protected DefaultFlowExecutionRepositoryCreator getRepositoryCreator() {
        SharedMapFlowExecutionRepositoryFactory factory = (SharedMapFlowExecutionRepositoryFactory)this.getRepositoryFactory();
        return (DefaultFlowExecutionRepositoryCreator)factory.getRepositoryCreator();
    }

    private static class DefaultFlowExecutionRepositoryCreator
    extends AbstractFlowExecutionRepositoryCreator {
        private transient UidGenerator continuationIdGenerator = new RandomGuidUidGenerator();
        private boolean alwaysGenerateNewNextKey = true;

        public DefaultFlowExecutionRepositoryCreator(FlowExecutionRepositoryServices repositoryServices) {
            super(repositoryServices);
        }

        public void setContinuationIdGenerator(UidGenerator continuationIdGenerator) {
            Assert.notNull((Object)continuationIdGenerator, (String)"The continuation id generator is required");
            this.continuationIdGenerator = continuationIdGenerator;
        }

        public void setAlwaysGenerateNewNextKey(boolean alwaysGenerateNewNextKey) {
            this.alwaysGenerateNewNextKey = alwaysGenerateNewNextKey;
        }

        public FlowExecutionRepository createRepository() {
            DefaultFlowExecutionRepository repository = new DefaultFlowExecutionRepository(this.getRepositoryServices());
            repository.setContinuationIdGenerator(this.continuationIdGenerator);
            repository.setAlwaysGenerateNewNextKey(this.alwaysGenerateNewNextKey);
            return repository;
        }

        public FlowExecutionRepository rehydrateRepository(FlowExecutionRepository repository) {
            DefaultFlowExecutionRepository defaultRepository = (DefaultFlowExecutionRepository)repository;
            defaultRepository.setRepositoryServices(this.getRepositoryServices());
            defaultRepository.setContinuationIdGenerator(this.continuationIdGenerator);
            return repository;
        }
    }
}

