/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.execution.repository.support;

import org.springframework.webflow.SharedMap;
import org.springframework.webflow.execution.FlowExecution;
import org.springframework.webflow.execution.repository.FlowExecutionKey;
import org.springframework.webflow.execution.repository.FlowExecutionLock;
import org.springframework.webflow.execution.repository.FlowExecutionRepository;
import org.springframework.webflow.execution.repository.FlowExecutionRepositoryException;

class RebindingFlowExecutionRepository
implements FlowExecutionRepository {
    private FlowExecutionRepository target;
    private Object key;
    private SharedMap map;

    public RebindingFlowExecutionRepository(FlowExecutionRepository target, Object key, SharedMap map) {
        this.target = target;
        this.key = key;
        this.map = map;
    }

    public FlowExecution createFlowExecution(String flowId) throws FlowExecutionRepositoryException {
        return this.target.createFlowExecution(flowId);
    }

    public FlowExecutionKey generateKey(FlowExecution flowExecution) throws FlowExecutionRepositoryException {
        return this.target.generateKey(flowExecution);
    }

    public FlowExecutionKey getNextKey(FlowExecution flowExecution, FlowExecutionKey key) throws FlowExecutionRepositoryException {
        return this.target.getNextKey(flowExecution, key);
    }

    public FlowExecutionLock getLock(FlowExecutionKey key) throws FlowExecutionRepositoryException {
        return this.target.getLock(key);
    }

    public FlowExecution getFlowExecution(FlowExecutionKey key) throws FlowExecutionRepositoryException {
        return this.target.getFlowExecution(key);
    }

    public void putFlowExecution(FlowExecutionKey key, FlowExecution flowExecution) throws FlowExecutionRepositoryException {
        this.target.putFlowExecution(key, flowExecution);
        this.rebind();
    }

    public void removeFlowExecution(FlowExecutionKey key) throws FlowExecutionRepositoryException {
        this.target.removeFlowExecution(key);
        this.rebind();
    }

    public FlowExecutionKey parseFlowExecutionKey(String encodedKey) {
        return this.target.parseFlowExecutionKey(encodedKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rebind() {
        Object object = this.map.getMutex();
        synchronized (object) {
            this.map.put(this.key, this.target);
        }
    }
}

