/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.execution.repository.support;

import org.springframework.util.Assert;
import org.springframework.webflow.ExternalContext;
import org.springframework.webflow.SharedMap;
import org.springframework.webflow.execution.repository.FlowExecutionRepository;
import org.springframework.webflow.execution.repository.FlowExecutionRepositoryFactory;
import org.springframework.webflow.execution.repository.support.FlowExecutionRepositoryCreator;
import org.springframework.webflow.execution.repository.support.RebindingFlowExecutionRepository;
import org.springframework.webflow.execution.repository.support.SessionMapLocator;
import org.springframework.webflow.execution.repository.support.SharedMapLocator;

public class SharedMapFlowExecutionRepositoryFactory
implements FlowExecutionRepositoryFactory {
    private FlowExecutionRepositoryCreator repositoryCreator;
    private SharedMapLocator sharedMapLocator = new SessionMapLocator();

    public SharedMapFlowExecutionRepositoryFactory(FlowExecutionRepositoryCreator repositoryCreator) {
        Assert.notNull((Object)repositoryCreator, (String)"The repository creator is required");
        this.repositoryCreator = repositoryCreator;
    }

    public FlowExecutionRepositoryCreator getRepositoryCreator() {
        return this.repositoryCreator;
    }

    public SharedMapLocator getSharedMapLocator() {
        return this.sharedMapLocator;
    }

    public void setSharedMapLocator(SharedMapLocator sharedMapLocator) {
        Assert.notNull((Object)sharedMapLocator, (String)"The shared map locator is required");
        this.sharedMapLocator = sharedMapLocator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FlowExecutionRepository getRepository(ExternalContext context) {
        SharedMap repositoryMap = this.sharedMapLocator.getMap(context);
        Object object = repositoryMap.getMutex();
        synchronized (object) {
            Object repositoryKey = this.getRepositoryKey();
            FlowExecutionRepository repository = (FlowExecutionRepository)repositoryMap.get(repositoryKey);
            if (repository == null) {
                repository = this.getRepositoryCreator().createRepository();
                repositoryMap.put(repositoryKey, repository);
            } else {
                this.getRepositoryCreator().rehydrateRepository(repository);
            }
            if (this.sharedMapLocator.requiresRebindOnChange()) {
                return new RebindingFlowExecutionRepository(repository, repositoryKey, repositoryMap);
            }
            return repository;
        }
    }

    protected Object getRepositoryKey() {
        return this.getRepositoryCreator().getClass().getName();
    }
}

