/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.executor;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.binding.mapping.AttributeMapper;
import org.springframework.util.Assert;
import org.springframework.webflow.AttributeMap;
import org.springframework.webflow.ExternalContext;
import org.springframework.webflow.FlowException;
import org.springframework.webflow.ViewSelection;
import org.springframework.webflow.execution.EventId;
import org.springframework.webflow.execution.FlowExecution;
import org.springframework.webflow.execution.FlowLocator;
import org.springframework.webflow.execution.repository.FlowExecutionKey;
import org.springframework.webflow.execution.repository.FlowExecutionLock;
import org.springframework.webflow.execution.repository.FlowExecutionRepository;
import org.springframework.webflow.execution.repository.FlowExecutionRepositoryFactory;
import org.springframework.webflow.execution.repository.support.DefaultFlowExecutionRepositoryFactory;
import org.springframework.webflow.executor.FlowExecutor;
import org.springframework.webflow.executor.RequestParameterInputMapper;
import org.springframework.webflow.executor.ResponseInstruction;
import org.springframework.webflow.support.ApplicationView;
import org.springframework.webflow.support.FlowExecutionRedirect;

public class FlowExecutorImpl
implements FlowExecutor {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private FlowExecutionRepositoryFactory repositoryFactory;
    private boolean redirectOnPause;
    private AttributeMapper inputMapper = new RequestParameterInputMapper();

    public FlowExecutorImpl(FlowLocator flowLocator) {
        this(new DefaultFlowExecutionRepositoryFactory(flowLocator));
    }

    public FlowExecutorImpl(FlowExecutionRepositoryFactory repositoryFactory) {
        Assert.notNull((Object)repositoryFactory, (String)"The repository factory for creating, saving, and restoring flow executions is required");
        this.repositoryFactory = repositoryFactory;
    }

    public FlowExecutionRepositoryFactory getRepositoryFactory() {
        return this.repositoryFactory;
    }

    public boolean isRedirectOnPause() {
        return this.redirectOnPause;
    }

    public void setRedirectOnPause(boolean b) {
        this.redirectOnPause = b;
    }

    public void setInputMapper(AttributeMapper inputMapper) {
        this.inputMapper = inputMapper;
    }

    public AttributeMapper getInputMapper() {
        return this.inputMapper;
    }

    public ResponseInstruction launch(String flowId, ExternalContext context) throws FlowException {
        FlowExecutionRepository repository = this.getRepository(context);
        FlowExecution flowExecution = repository.createFlowExecution(flowId);
        ViewSelection selectedView = flowExecution.start(this.createInput(context), context);
        if (flowExecution.isActive()) {
            FlowExecutionKey flowExecutionKey = repository.generateKey(flowExecution);
            repository.putFlowExecution(flowExecutionKey, flowExecution);
            return new ResponseInstruction(flowExecutionKey.toString(), flowExecution, this.redirectOnPauseIfNecessary(selectedView));
        }
        return new ResponseInstruction(flowExecution, selectedView);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseInstruction signalEvent(String eventId, String flowExecutionKey, ExternalContext context) throws FlowException {
        FlowExecutionRepository repository = this.getRepository(context);
        FlowExecutionKey repositoryKey = repository.parseFlowExecutionKey(flowExecutionKey);
        FlowExecutionLock lock = repository.getLock(repositoryKey);
        lock.lock();
        try {
            FlowExecution flowExecution = repository.getFlowExecution(repositoryKey);
            ViewSelection selectedView = flowExecution.signalEvent(new EventId(eventId), context);
            if (flowExecution.isActive()) {
                repositoryKey = repository.getNextKey(flowExecution, repositoryKey);
                repository.putFlowExecution(repositoryKey, flowExecution);
                ResponseInstruction responseInstruction = new ResponseInstruction(repositoryKey.toString(), flowExecution, this.redirectOnPauseIfNecessary(selectedView));
                return responseInstruction;
            }
            repository.removeFlowExecution(repositoryKey);
            ResponseInstruction responseInstruction = new ResponseInstruction(flowExecution, selectedView);
            return responseInstruction;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseInstruction refresh(String flowExecutionKey, ExternalContext context) throws FlowException {
        FlowExecutionRepository repository = this.getRepository(context);
        FlowExecutionKey repositoryKey = repository.parseFlowExecutionKey(flowExecutionKey);
        FlowExecutionLock lock = repository.getLock(repositoryKey);
        lock.lock();
        try {
            FlowExecution flowExecution = repository.getFlowExecution(repositoryKey);
            ViewSelection selectedView = flowExecution.refresh(context);
            ResponseInstruction responseInstruction = new ResponseInstruction(repositoryKey.toString(), flowExecution, selectedView);
            return responseInstruction;
        }
        finally {
            lock.unlock();
        }
    }

    protected FlowExecutionRepository getRepository(ExternalContext context) {
        return this.repositoryFactory.getRepository(context);
    }

    protected AttributeMap createInput(ExternalContext context) {
        if (this.inputMapper != null) {
            AttributeMap inputMap = new AttributeMap();
            this.inputMapper.map((Object)context, (Object)inputMap, null);
            return inputMap;
        }
        return null;
    }

    protected ViewSelection redirectOnPauseIfNecessary(ViewSelection selectedView) {
        if (selectedView instanceof ApplicationView && this.redirectOnPause) {
            return FlowExecutionRedirect.INSTANCE;
        }
        return selectedView;
    }
}

