/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.executor.jsf;

import javax.faces.application.NavigationHandler;
import javax.faces.context.FacesContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.web.jsf.DecoratingNavigationHandler;
import org.springframework.webflow.AttributeMap;
import org.springframework.webflow.ExternalContext;
import org.springframework.webflow.ViewSelection;
import org.springframework.webflow.execution.EventId;
import org.springframework.webflow.execution.FlowExecution;
import org.springframework.webflow.execution.repository.FlowExecutionRepository;
import org.springframework.webflow.execution.repository.FlowExecutionRepositoryFactory;
import org.springframework.webflow.executor.jsf.FlowExecutionHolder;
import org.springframework.webflow.executor.jsf.FlowExecutionHolderUtils;
import org.springframework.webflow.executor.jsf.FlowFacesUtils;
import org.springframework.webflow.executor.jsf.FlowNavigationHandlerArgumentExtractor;
import org.springframework.webflow.executor.jsf.JsfExternalContext;
import org.springframework.webflow.executor.support.FlowExecutorArgumentExtractor;

public class FlowNavigationHandler
extends DecoratingNavigationHandler {
    protected final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private FlowExecutionRepositoryFactory repositoryFactory;
    private FlowExecutorArgumentExtractor argumentExtractor = new FlowNavigationHandlerArgumentExtractor();

    public FlowNavigationHandler() {
    }

    public FlowNavigationHandler(NavigationHandler originalNavigationHandler) {
        super(originalNavigationHandler);
    }

    public FlowExecutionRepositoryFactory getRepositoryFactory() {
        return this.repositoryFactory;
    }

    public void setRepositoryFactory(FlowExecutionRepositoryFactory repositoryFactory) {
        this.repositoryFactory = repositoryFactory;
    }

    public FlowExecutorArgumentExtractor getArgumentExtractor() {
        return this.argumentExtractor;
    }

    public void setArgumentExtractor(FlowExecutorArgumentExtractor argumentExtractor) {
        this.argumentExtractor = argumentExtractor;
    }

    public void handleNavigation(FacesContext facesContext, String fromAction, String outcome, NavigationHandler originalNavigationHandler) {
        JsfExternalContext context = new JsfExternalContext(facesContext, fromAction, outcome);
        if (FlowExecutionHolderUtils.isFlowExecutionRestored(facesContext)) {
            if (this.argumentExtractor.isEventIdPresent(context)) {
                String eventId = this.argumentExtractor.extractEventId(context);
                FlowExecutionHolder holder = FlowExecutionHolderUtils.getFlowExecutionHolder(facesContext);
                ViewSelection selectedView = holder.getFlowExecution().signalEvent(new EventId(eventId), context);
                holder.setViewSelection(selectedView);
                holder.markNeedsSave();
            }
        } else if (this.argumentExtractor.isFlowIdPresent(context)) {
            String flowId = this.argumentExtractor.extractFlowId(context);
            FlowExecution flowExecution = this.getRepository(context).createFlowExecution(flowId);
            FlowExecutionHolder holder = new FlowExecutionHolder(flowExecution);
            FlowExecutionHolderUtils.setFlowExecutionHolder(holder, facesContext);
            ViewSelection selectedView = flowExecution.start(this.createInput(flowExecution, context), context);
            holder.setViewSelection(selectedView);
            holder.markNeedsSave();
        } else {
            originalNavigationHandler.handleNavigation(facesContext, fromAction, outcome);
        }
    }

    protected FlowExecutionRepository getRepository(JsfExternalContext context) {
        if (this.repositoryFactory == null) {
            this.repositoryFactory = FlowFacesUtils.getRepositoryFactory(context.getFacesContext());
        }
        return this.repositoryFactory.getRepository(context);
    }

    protected AttributeMap createInput(FlowExecution flowExecution, ExternalContext context) {
        return null;
    }
}

