/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.executor.jsf;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.webflow.AttributeMap;
import org.springframework.webflow.ExternalContext;
import org.springframework.webflow.ViewSelection;
import org.springframework.webflow.execution.FlowExecution;
import org.springframework.webflow.execution.repository.FlowExecutionKey;
import org.springframework.webflow.execution.repository.FlowExecutionRepository;
import org.springframework.webflow.execution.repository.FlowExecutionRepositoryFactory;
import org.springframework.webflow.executor.jsf.FlowExecutionHolder;
import org.springframework.webflow.executor.jsf.FlowExecutionHolderUtils;
import org.springframework.webflow.executor.jsf.FlowFacesUtils;
import org.springframework.webflow.executor.jsf.JsfExternalContext;
import org.springframework.webflow.executor.jsf.ViewIdMapper;
import org.springframework.webflow.executor.support.FlowExecutorArgumentExtractor;
import org.springframework.webflow.support.ApplicationView;
import org.springframework.webflow.support.ExternalRedirect;
import org.springframework.webflow.support.FlowExecutionRedirect;
import org.springframework.webflow.support.FlowRedirect;

public class FlowPhaseListener
implements PhaseListener {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private FlowExecutionRepositoryFactory repositoryFactory;
    private FlowExecutorArgumentExtractor argumentExtractor = new FlowExecutorArgumentExtractor();
    private ViewIdMapper viewIdMapper = new DefaultViewIdMapper();

    public FlowExecutionRepositoryFactory getRepositoryFactory() {
        return this.repositoryFactory;
    }

    public void setRepositoryFactory(FlowExecutionRepositoryFactory repositoryFactory) {
        this.repositoryFactory = repositoryFactory;
    }

    public FlowExecutorArgumentExtractor getArgumentExtractor() {
        return this.argumentExtractor;
    }

    public void setArgumentExtractor(FlowExecutorArgumentExtractor argumentExtractor) {
        this.argumentExtractor = argumentExtractor;
    }

    public ViewIdMapper getViewIdMapper() {
        return this.viewIdMapper;
    }

    public void setViewIdMapper(ViewIdMapper viewIdMapper) {
        this.viewIdMapper = viewIdMapper;
    }

    public PhaseId getPhaseId() {
        return PhaseId.ANY_PHASE;
    }

    public void beforePhase(PhaseEvent event) {
        if (event.getPhaseId() == PhaseId.RESTORE_VIEW) {
            this.restoreFlowExecution(event.getFacesContext());
        } else if (event.getPhaseId() == PhaseId.RENDER_RESPONSE && FlowExecutionHolderUtils.isFlowExecutionRestored(event.getFacesContext())) {
            JsfExternalContext context = new JsfExternalContext(event.getFacesContext());
            this.prepareResponse(context, FlowExecutionHolderUtils.getFlowExecutionHolder(event.getFacesContext()));
        }
    }

    public void afterPhase(PhaseEvent event) {
        if (event.getPhaseId() == PhaseId.RENDER_RESPONSE && FlowExecutionHolderUtils.isFlowExecutionChanged(event.getFacesContext())) {
            JsfExternalContext context = new JsfExternalContext(event.getFacesContext());
            this.saveFlowExecution(context, FlowExecutionHolderUtils.getFlowExecutionHolder(event.getFacesContext()));
        }
    }

    protected void restoreFlowExecution(FacesContext facesContext) {
        JsfExternalContext context = new JsfExternalContext(facesContext);
        if (this.argumentExtractor.isFlowExecutionKeyPresent(context)) {
            FlowExecutionRepository repository = this.getRepository(context);
            FlowExecutionKey flowExecutionKey = repository.parseFlowExecutionKey(this.argumentExtractor.extractFlowExecutionKey(context));
            FlowExecution flowExecution = repository.getFlowExecution(flowExecutionKey);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Loaded existing flow execution from repository with id '" + flowExecutionKey + "'"));
            }
            FlowExecutionHolderUtils.setFlowExecutionHolder(new FlowExecutionHolder(flowExecutionKey, flowExecution), facesContext);
        } else if (this.argumentExtractor.isFlowIdPresent(context)) {
            String flowId = this.argumentExtractor.extractFlowId(context);
            FlowExecutionRepository repository = this.getRepository(context);
            FlowExecution flowExecution = repository.createFlowExecution(flowId);
            FlowExecutionHolder holder = new FlowExecutionHolder(flowExecution);
            FlowExecutionHolderUtils.setFlowExecutionHolder(holder, facesContext);
            ViewSelection selectedView = flowExecution.start(this.createInput(flowExecution, context), context);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Started new flow execution");
            }
            holder.setViewSelection(selectedView);
            holder.markNeedsSave();
        }
    }

    protected AttributeMap createInput(FlowExecution flowExecution, ExternalContext context) {
        return null;
    }

    protected void prepareResponse(JsfExternalContext context, FlowExecutionHolder holder) {
        ViewSelection selectedView;
        if (holder.needsSave()) {
            this.generateKey(context, holder);
        }
        if ((selectedView = holder.getViewSelection()) == null) {
            selectedView = holder.getFlowExecution().refresh(context);
            holder.setViewSelection(selectedView);
        }
        if (selectedView instanceof ApplicationView) {
            this.prepareApplicationView(context.getFacesContext(), holder);
        } else if (selectedView instanceof FlowExecutionRedirect) {
            if (holder.needsSave()) {
                this.saveFlowExecution(context, holder);
            }
            String url = this.argumentExtractor.createFlowExecutionUrl(holder.getFlowExecutionKey().toString(), holder.getFlowExecution(), context);
            this.sendRedirect(url, context);
        } else if (selectedView instanceof ExternalRedirect) {
            if (holder.needsSave()) {
                this.saveFlowExecution(context, holder);
            }
            String url = this.argumentExtractor.createExternalUrl((ExternalRedirect)holder.getViewSelection(), holder.getFlowExecutionKey().toString(), context);
            this.sendRedirect(url, context);
        } else if (selectedView instanceof FlowRedirect) {
            if (holder.needsSave()) {
                this.saveFlowExecution(context, holder);
            }
            String url = this.argumentExtractor.createFlowUrl((FlowRedirect)holder.getViewSelection(), context);
            this.sendRedirect(url, context);
        }
    }

    protected void prepareApplicationView(FacesContext facesContext, FlowExecutionHolder holder) {
        ApplicationView forward = (ApplicationView)holder.getViewSelection();
        if (forward != null) {
            this.putInto(facesContext.getExternalContext().getRequestMap(), forward.getModel());
            this.updateViewRoot(facesContext, this.viewIdMapper.mapViewId(forward.getViewName()));
        }
        Map requestMap = facesContext.getExternalContext().getRequestMap();
        this.argumentExtractor.put(holder.getFlowExecutionKey().toString(), requestMap);
        this.argumentExtractor.put(holder.getFlowExecution(), requestMap);
    }

    private void updateViewRoot(FacesContext facesContext, String viewId) {
        UIViewRoot viewRoot = facesContext.getViewRoot();
        if (viewRoot == null || this.hasViewChanged(viewRoot, viewId)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Creating new view with id '" + viewId + "' from previous view with id '" + viewRoot.getViewId() + "'"));
            }
            ViewHandler handler = facesContext.getApplication().getViewHandler();
            UIViewRoot view = handler.createView(facesContext, viewId);
            facesContext.setViewRoot(view);
        }
    }

    private boolean hasViewChanged(UIViewRoot viewRoot, String viewId) {
        return !viewRoot.getViewId().equals(viewId);
    }

    private void generateKey(JsfExternalContext context, FlowExecutionHolder holder) {
        FlowExecution flowExecution = holder.getFlowExecution();
        if (flowExecution.isActive()) {
            FlowExecutionKey flowExecutionKey = holder.getFlowExecutionKey();
            FlowExecutionRepository repository = this.getRepository(context);
            flowExecutionKey = flowExecutionKey == null ? repository.generateKey(flowExecution) : repository.getNextKey(flowExecution, flowExecutionKey);
            holder.setFlowExecutionKey(flowExecutionKey);
        }
    }

    protected void saveFlowExecution(JsfExternalContext context, FlowExecutionHolder holder) {
        FlowExecution flowExecution = holder.getFlowExecution();
        FlowExecutionRepository repository = this.getRepository(context);
        if (flowExecution.isActive()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Saving continuation to repository with key " + holder.getFlowExecutionKey()));
            }
            repository.putFlowExecution(holder.getFlowExecutionKey(), flowExecution);
        } else if (holder.getFlowExecutionKey() != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Removing execution in repository with key '" + holder.getFlowExecutionKey() + "'"));
            }
            repository.removeFlowExecution(holder.getFlowExecutionKey());
        }
    }

    protected FlowExecutionRepository getRepository(JsfExternalContext context) {
        if (this.repositoryFactory == null) {
            this.repositoryFactory = FlowFacesUtils.getRepositoryFactory(context.getFacesContext());
        }
        return this.repositoryFactory.getRepository(context);
    }

    private void putInto(Map targetMap, Map map) {
        try {
            targetMap.putAll(map);
        }
        catch (UnsupportedOperationException e) {
            Iterator it = map.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                targetMap.put(entry.getKey(), entry.getValue());
            }
        }
    }

    private void sendRedirect(String url, JsfExternalContext context) {
        try {
            context.getFacesContext().getExternalContext().redirect(url);
            context.getFacesContext().responseComplete();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not send redirect to " + url);
        }
    }

    public static class DefaultViewIdMapper
    implements ViewIdMapper {
        public String mapViewId(String viewName) {
            return viewName;
        }
    }
}

