/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.executor.mvc;

import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.mvc.AbstractController;
import org.springframework.web.servlet.view.RedirectView;
import org.springframework.webflow.ExternalContext;
import org.springframework.webflow.context.servlet.ServletExternalContext;
import org.springframework.webflow.execution.FlowLocator;
import org.springframework.webflow.executor.FlowExecutor;
import org.springframework.webflow.executor.FlowExecutorImpl;
import org.springframework.webflow.executor.ResponseInstruction;
import org.springframework.webflow.executor.support.FlowExecutorArgumentExtractor;
import org.springframework.webflow.executor.support.FlowRequestHandler;
import org.springframework.webflow.support.ApplicationView;
import org.springframework.webflow.support.ExternalRedirect;
import org.springframework.webflow.support.FlowRedirect;

public class FlowController
extends AbstractController
implements InitializingBean {
    private FlowExecutor flowExecutor;
    private FlowExecutorArgumentExtractor argumentExtractor = new FlowExecutorArgumentExtractor();

    public FlowController() {
        this.setCacheSeconds(0);
    }

    public FlowExecutor getFlowExecutor() {
        return this.flowExecutor;
    }

    public void setFlowExecutor(FlowExecutor flowExecutor) {
        this.flowExecutor = flowExecutor;
    }

    public void setFlowLocator(FlowLocator flowLocator) {
        this.flowExecutor = new FlowExecutorImpl(flowLocator);
    }

    public FlowExecutorArgumentExtractor getArgumentExtractor() {
        return this.argumentExtractor;
    }

    public void setArgumentExtractor(FlowExecutorArgumentExtractor parameterExtractor) {
        this.argumentExtractor = parameterExtractor;
    }

    public void setDefaultFlowId(String defaultFlowId) {
        this.argumentExtractor.setDefaultFlowId(defaultFlowId);
    }

    public void afterPropertiesSet() {
        Assert.notNull((Object)this.flowExecutor, (String)"The flow executor property is required");
        Assert.notNull((Object)this.argumentExtractor, (String)"The argument extractor property is required");
    }

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ServletExternalContext context = new ServletExternalContext(this.getServletContext(), request, response);
        ResponseInstruction responseInstruction = this.createRequestHandler().handleFlowRequest(context);
        return this.toModelAndView(responseInstruction, context);
    }

    protected FlowRequestHandler createRequestHandler() {
        return new FlowRequestHandler(this.getFlowExecutor(), this.getArgumentExtractor());
    }

    protected ModelAndView toModelAndView(ResponseInstruction response, ExternalContext context) {
        if (response.isApplicationView()) {
            ApplicationView view = (ApplicationView)response.getViewSelection();
            HashMap model = new HashMap(view.getModel());
            this.argumentExtractor.put(response.getFlowExecutionKey(), model);
            this.argumentExtractor.put(response.getFlowExecutionContext(), model);
            return new ModelAndView(view.getViewName(), model);
        }
        if (response.isFlowExecutionRedirect()) {
            String flowExecutionUrl = this.argumentExtractor.createFlowExecutionUrl(response.getFlowExecutionKey(), response.getFlowExecutionContext(), context);
            return new ModelAndView((View)new RedirectView(flowExecutionUrl));
        }
        if (response.isExternalRedirect()) {
            ExternalRedirect redirect = (ExternalRedirect)response.getViewSelection();
            String externalUrl = this.argumentExtractor.createExternalUrl(redirect, response.getFlowExecutionKey(), context);
            return new ModelAndView((View)new RedirectView(externalUrl));
        }
        if (response.isFlowRedirect()) {
            String flowUrl = this.argumentExtractor.createFlowUrl((FlowRedirect)response.getViewSelection(), context);
            return new ModelAndView((View)new RedirectView(flowUrl));
        }
        if (response.isNull()) {
            return null;
        }
        throw new IllegalArgumentException("Don't know how to handle response instruction " + response);
    }
}

