/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.executor.mvc;

import java.util.HashMap;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletSession;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.web.portlet.ModelAndView;
import org.springframework.web.portlet.mvc.AbstractController;
import org.springframework.webflow.context.portlet.PortletExternalContext;
import org.springframework.webflow.execution.FlowLocator;
import org.springframework.webflow.execution.repository.support.DefaultFlowExecutionRepositoryFactory;
import org.springframework.webflow.executor.FlowExecutor;
import org.springframework.webflow.executor.FlowExecutorImpl;
import org.springframework.webflow.executor.ResponseInstruction;
import org.springframework.webflow.executor.support.FlowExecutorArgumentExtractor;
import org.springframework.webflow.support.ApplicationView;
import org.springframework.webflow.support.ExternalRedirect;
import org.springframework.webflow.support.FlowRedirect;

public class PortletFlowController
extends AbstractController
implements InitializingBean {
    private FlowExecutor flowExecutor;
    private FlowExecutorArgumentExtractor argumentExtractor = new FlowExecutorArgumentExtractor();

    public PortletFlowController() {
        this.setCacheSeconds(0);
        this.setSynchronizeOnSession(true);
    }

    public FlowExecutor getFlowExecutor() {
        return this.flowExecutor;
    }

    public void setFlowExecutor(FlowExecutor flowExecutor) {
        this.flowExecutor = flowExecutor;
    }

    public void setFlowLocator(FlowLocator flowLocator) {
        this.flowExecutor = new FlowExecutorImpl(new DefaultFlowExecutionRepositoryFactory(flowLocator));
    }

    public FlowExecutorArgumentExtractor getArgumentExtractor() {
        return this.argumentExtractor;
    }

    public void setArgumentExtractor(FlowExecutorArgumentExtractor argumentExtractor) {
        this.argumentExtractor = argumentExtractor;
    }

    public void setDefaultFlowId(String defaultFlowId) {
        this.argumentExtractor.setDefaultFlowId(defaultFlowId);
    }

    public void afterPropertiesSet() {
        Assert.notNull((Object)this.flowExecutor, (String)"The flow executor property is required");
        Assert.notNull((Object)this.argumentExtractor, (String)"The argument extractor property is required");
    }

    protected ModelAndView handleRenderRequestInternal(RenderRequest request, RenderResponse response) throws Exception {
        PortletExternalContext context = new PortletExternalContext(this.getPortletContext(), (PortletRequest)request, (PortletResponse)response);
        if (this.argumentExtractor.isFlowExecutionKeyPresent(context)) {
            String flowExecutionKey = this.argumentExtractor.extractFlowExecutionKey(context);
            ResponseInstruction responseInstruction = this.extractActionResponseInstruction((PortletRequest)request);
            if (responseInstruction == null) {
                return this.toModelAndView(this.flowExecutor.refresh(flowExecutionKey, context));
            }
            return this.toModelAndView(responseInstruction);
        }
        ResponseInstruction responseInstruction = this.extractActionResponseInstruction((PortletRequest)request);
        if (responseInstruction == null) {
            String flowId = this.argumentExtractor.extractFlowId(context);
            return this.toModelAndView(this.flowExecutor.launch(flowId, context));
        }
        return this.toModelAndView(responseInstruction);
    }

    protected void handleActionRequestInternal(ActionRequest request, ActionResponse response) throws Exception {
        PortletExternalContext context = new PortletExternalContext(this.getPortletContext(), (PortletRequest)request, (PortletResponse)response);
        String flowExecutionKey = this.argumentExtractor.extractFlowExecutionKey(context);
        String eventId = this.argumentExtractor.extractEventId(context);
        ResponseInstruction responseInstruction = this.flowExecutor.signalEvent(eventId, flowExecutionKey, context);
        if (responseInstruction.isApplicationView()) {
            if (responseInstruction.isActiveView()) {
                response.setRenderParameter(this.argumentExtractor.getFlowExecutionKeyParameterName(), responseInstruction.getFlowExecutionKey());
            }
            this.exposeToRenderPhase(responseInstruction, request);
        } else if (responseInstruction.isFlowExecutionRedirect()) {
            response.setRenderParameter(this.argumentExtractor.getFlowExecutionKeyParameterName(), responseInstruction.getFlowExecutionKey());
        } else if (responseInstruction.isFlowRedirect()) {
            String flowId = ((FlowRedirect)responseInstruction.getViewSelection()).getFlowId();
            response.setRenderParameter(this.argumentExtractor.getFlowIdParameterName(), flowId);
        } else if (responseInstruction.isExternalRedirect()) {
            ExternalRedirect redirect = (ExternalRedirect)responseInstruction.getViewSelection();
            String url = this.argumentExtractor.createExternalUrl(redirect, flowExecutionKey, context);
            response.sendRedirect(url);
        } else {
            throw new IllegalArgumentException("Don't know how to handle response instruction " + responseInstruction);
        }
    }

    private ResponseInstruction extractActionResponseInstruction(PortletRequest request) {
        String attributeName;
        PortletSession session = request.getPortletSession(false);
        ResponseInstruction response = null;
        if (session != null && (response = (ResponseInstruction)session.getAttribute(attributeName = this.getAttributeName())) != null) {
            session.removeAttribute(attributeName);
        }
        return response;
    }

    protected ModelAndView toModelAndView(ResponseInstruction response) {
        if (response.isApplicationView()) {
            ApplicationView forward = (ApplicationView)response.getViewSelection();
            HashMap model = new HashMap(forward.getModel());
            this.argumentExtractor.put(response.getFlowExecutionKey(), model);
            this.argumentExtractor.put(response.getFlowExecutionContext(), model);
            return new ModelAndView(forward.getViewName(), model);
        }
        if (response.isNull()) {
            return null;
        }
        throw new IllegalArgumentException("Don't know how to handle response instruction " + response);
    }

    private void exposeToRenderPhase(ResponseInstruction responseInstruction, ActionRequest request) {
        PortletSession session = request.getPortletSession(false);
        if (session != null) {
            session.setAttribute(this.getAttributeName(), (Object)responseInstruction);
        }
    }

    private String getAttributeName() {
        return "actionRequest.responseInstruction";
    }
}

