/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.executor.support;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Iterator;
import java.util.Map;
import org.springframework.core.JdkVersion;
import org.springframework.core.style.StylerUtils;
import org.springframework.util.StringUtils;
import org.springframework.webflow.ExternalContext;
import org.springframework.webflow.FlowExecutionContext;
import org.springframework.webflow.ParameterMap;
import org.springframework.webflow.executor.support.FlowExecutorArgumentExtractionException;
import org.springframework.webflow.support.ExternalRedirect;
import org.springframework.webflow.support.FlowRedirect;

public class FlowExecutorArgumentExtractor {
    private static final String FLOW_ID_PARAMETER = "_flowId";
    private static final String FLOW_EXECUTION_KEY_PARAMETER = "_flowExecutionKey";
    private static final String EVENT_ID_PARAMETER = "_eventId";
    private static final String PARAMETER_VALUE_DELIMITER = "_";
    private String flowIdParameterName = "_flowId";
    private String defaultFlowId;
    private String flowExecutionKeyParameterName = "_flowExecutionKey";
    private String eventIdParameterName = "_eventId";
    private String parameterValueDelimiter = "_";
    private static final String FLOW_EXECUTION_KEY_ATTRIBUTE = "flowExecutionKey";
    private static final String FLOW_EXECUTION_CONTEXT_ATTRIBUTE = "flowExecutionContext";
    private static final String DEFAULT_URL_ENCODING_SCHEME = "UTF-8";
    private String flowExecutionKeyAttributeName = "flowExecutionKey";
    private String flowExecutionContextAttributeName = "flowExecutionContext";
    private boolean redirectContextRelative = true;
    private String urlEncodingScheme = "UTF-8";

    public String getFlowIdParameterName() {
        return this.flowIdParameterName;
    }

    public void setFlowIdParameterName(String flowIdParameterName) {
        this.flowIdParameterName = flowIdParameterName;
    }

    public String getDefaultFlowId() {
        return this.defaultFlowId;
    }

    public void setDefaultFlowId(String defaultFlowId) {
        this.defaultFlowId = defaultFlowId;
    }

    public String getFlowExecutionKeyParameterName() {
        return this.flowExecutionKeyParameterName;
    }

    public void setFlowExecutionKeyParameterName(String flowExecutionKeyParameterName) {
        this.flowExecutionKeyParameterName = flowExecutionKeyParameterName;
    }

    public String getEventIdParameterName() {
        return this.eventIdParameterName;
    }

    public void setEventIdParameterName(String eventIdParameterName) {
        this.eventIdParameterName = eventIdParameterName;
    }

    public String getParameterValueDelimiter() {
        return this.parameterValueDelimiter;
    }

    public void setParameterValueDelimiter(String parameterValueDelimiter) {
        this.parameterValueDelimiter = parameterValueDelimiter;
    }

    public boolean isFlowIdPresent(ExternalContext context) {
        return context.getRequestParameterMap().contains(this.getFlowIdParameterName());
    }

    public String extractFlowId(ExternalContext context) throws FlowExecutorArgumentExtractionException {
        String flowId = context.getRequestParameterMap().get(this.getFlowIdParameterName());
        if (flowId == null) {
            flowId = this.defaultFlowId;
        }
        if (!StringUtils.hasText((String)flowId)) {
            throw new FlowExecutorArgumentExtractionException("Unable to extract the flowId argument: make sure the client provides the '" + this.getFlowIdParameterName() + "' parameter as input or set the 'defaultFlowId' property; " + "the parameters provided in this request are: " + StylerUtils.style((Object)context.getRequestParameterMap()));
        }
        return flowId;
    }

    public boolean isFlowExecutionKeyPresent(ExternalContext context) {
        return context.getRequestParameterMap().contains(this.getFlowExecutionKeyParameterName());
    }

    public String extractFlowExecutionKey(ExternalContext context) throws FlowExecutorArgumentExtractionException {
        String encodedKey = context.getRequestParameterMap().get(this.getFlowExecutionKeyParameterName());
        if (!StringUtils.hasText((String)encodedKey)) {
            throw new FlowExecutorArgumentExtractionException("Unable to extract the flowExecutionKey argument: make sure the client provides the '" + this.getFlowExecutionKeyParameterName() + "' parameter as input; the parameters provided in this request are: " + StylerUtils.style((Object)context.getRequestParameterMap()));
        }
        return encodedKey;
    }

    public boolean isEventIdPresent(ExternalContext context) {
        return this.findParameter(this.getEventIdParameterName(), context.getRequestParameterMap()) != null;
    }

    public String extractEventId(ExternalContext context) throws FlowExecutorArgumentExtractionException {
        String eventId = this.findParameter(this.getEventIdParameterName(), context.getRequestParameterMap());
        if (!StringUtils.hasText((String)eventId)) {
            throw new FlowExecutorArgumentExtractionException("Unable to extract the eventId argument: make sure the client provides the '" + this.getEventIdParameterName() + "' parameter as input along with the '" + this.getFlowExecutionKeyParameterName() + "' parameter; the parameters provided in this request are: " + StylerUtils.style((Object)context.getRequestParameterMap()));
        }
        return eventId;
    }

    private String findParameter(String logicalParameterName, ParameterMap parameters) {
        String value = parameters.get(logicalParameterName);
        if (value != null) {
            return value;
        }
        String prefix = logicalParameterName + this.getParameterValueDelimiter();
        Iterator paramNames = parameters.getMap().keySet().iterator();
        while (paramNames.hasNext()) {
            String paramName = (String)paramNames.next();
            if (!paramName.startsWith(prefix)) continue;
            String strValue = paramName.substring(prefix.length());
            if (strValue.endsWith(".x") || strValue.endsWith(".y")) {
                strValue = strValue.substring(0, strValue.length() - 2);
            }
            return strValue;
        }
        return null;
    }

    public String getFlowExecutionKeyAttributeName() {
        return this.flowExecutionKeyAttributeName;
    }

    public void setFlowExecutionKeyAttributeName(String flowExecutionKeyAttributeName) {
        this.flowExecutionKeyAttributeName = flowExecutionKeyAttributeName;
    }

    public String getFlowExecutionContextAttributeName() {
        return this.flowExecutionContextAttributeName;
    }

    public void setFlowExecutionContextAttributeName(String flowExecutionContextAttributeName) {
        this.flowExecutionContextAttributeName = flowExecutionContextAttributeName;
    }

    public void setRedirectContextRelative(boolean redirectContextRelative) {
        this.redirectContextRelative = redirectContextRelative;
    }

    public boolean isRedirectContextRelative() {
        return this.redirectContextRelative;
    }

    public String getUrlEncodingScheme() {
        return this.urlEncodingScheme;
    }

    public void setUrlEncodingScheme(String urlEncodingScheme) {
        this.urlEncodingScheme = urlEncodingScheme;
    }

    public String createFlowUrl(FlowRedirect flowRedirect, ExternalContext externalContext) {
        StringBuffer flowUrl = new StringBuffer();
        flowUrl.append(externalContext.getContextPath());
        flowUrl.append(externalContext.getDispatcherPath());
        flowUrl.append('?');
        this.appendQueryParameter(this.getFlowIdParameterName(), flowRedirect.getFlowId(), flowUrl);
        if (!flowRedirect.getInput().isEmpty()) {
            flowUrl.append('&');
        }
        this.appendQueryParameters(flowRedirect.getInput(), flowUrl);
        return flowUrl.toString();
    }

    public String createFlowExecutionUrl(String flowExecutionKey, FlowExecutionContext flowExecution, ExternalContext context) {
        StringBuffer flowExecutionUrl = new StringBuffer();
        flowExecutionUrl.append(context.getContextPath());
        flowExecutionUrl.append(context.getDispatcherPath());
        flowExecutionUrl.append('?');
        this.appendQueryParameter(this.getFlowExecutionKeyParameterName(), flowExecutionKey, flowExecutionUrl);
        return flowExecutionUrl.toString();
    }

    public String createExternalUrl(ExternalRedirect redirect, String flowExecutionKey, ExternalContext context) {
        StringBuffer externalUrl = new StringBuffer();
        if (redirect.getUrl().startsWith("/") && this.isRedirectContextRelative()) {
            externalUrl.append(context.getContextPath());
        }
        externalUrl.append(redirect.getUrl());
        if (flowExecutionKey != null) {
            boolean first;
            boolean bl = first = redirect.getUrl().indexOf(63) < 0;
            if (first) {
                externalUrl.append('?');
            } else {
                externalUrl.append('&');
            }
            this.appendQueryParameter(this.flowExecutionKeyParameterName, flowExecutionKey, externalUrl);
        }
        return externalUrl.toString();
    }

    public void put(String flowExecutionKey, Map model) {
        if (flowExecutionKey != null) {
            model.put(this.getFlowExecutionKeyAttributeName(), flowExecutionKey);
        }
    }

    public void put(FlowExecutionContext context, Map model) {
        model.put(this.getFlowExecutionContextAttributeName(), context);
    }

    protected String encodeValue(Object value) {
        return value != null ? this.urlEncode(value.toString()) : "";
    }

    protected void appendQueryParameters(Map map, StringBuffer targetUrl) {
        Iterator entries = map.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            this.appendQueryParameter(entry.getKey(), entry.getValue(), targetUrl);
            if (!entries.hasNext()) continue;
            targetUrl.append('&');
        }
    }

    protected void appendQueryParameter(Object key, Object value, StringBuffer targetUrl) {
        String encodedKey = this.urlEncode(key.toString());
        String encodedValue = this.encodeValue(value);
        targetUrl.append(encodedKey).append('=').append(encodedValue);
    }

    private String urlEncode(String input) {
        if (JdkVersion.getMajorJavaVersion() < 1) {
            return URLEncoder.encode(input);
        }
        try {
            return URLEncoder.encode(input, this.urlEncodingScheme);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("Cannot encode URL " + input);
        }
    }
}

